﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.SoundFoundation.Projects;
using System.Collections.Generic;
using System.Linq;

namespace NintendoWare.SoundProjectUtility
{
    internal static class ComponentEx
    {
        /// <summary>
        /// <paramref name="topComponent"/> 以下のツリーをたどり全ての <see cref="Component"/> を列挙します。
        /// </summary>
        /// <param name="topComponent">列挙したいツリーのトップのノードです。</param>
        /// <returns><see cref="Component"/> のシーケンスです。<paramref name="topComponent"/> を含みます。</returns>
        public static IEnumerable<Component> EnumerateComponentTree(this Component topComponent)
        {
            if (topComponent == null)
            {
                yield break;
            }

            yield return topComponent;

            foreach (var component in topComponent.Children.Cast<Component>().SelectMany(it => EnumerateComponentTree(it)))
            {
                yield return component;
            }
        }
    }
}
