﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Preview.Communications.Ctrl
{
    using System;
    using System.Diagnostics;
    using System.Text;
    using NintendoWare.SoundMaker.Framework.Preview.Communications;
    using NintendoWare.SoundMaker.Framework.Preview.Communications.Sre;
    using NintendoWare.SoundMaker.Windows.Forms;

    public delegate void UpdateSoundHandleCallbackDelegate(uint index, SoundHandleState state);

    public enum SoundHandleState
    {
        Disabled = 0,
        Stopped = 1,
        Playing = 2,
        Paused = 3,
    }

    public class UpdateSoundHandleInfoPacket : CtrlPacket
    {
        private static bool _received = true;

        public static UpdateSoundHandleCallbackDelegate UpdateSoundHandleCallbackDelegate
        {
            get; set;
        }

        public static bool Received
        {
            get { return _received; }
            set { _received = value; }
        }

        /// <summary>
        /// パケットの種類
        /// </summary>
        public override ushort PacketType
        {
            get { return Constants.SNDCTRL_UPDATE_SOUND_HANDLE_INFO; }
        }

        /// <summary>
        /// ストリームからデータを読み込みます。
        /// </summary>
        /// <param name="reader">対象ストリーム</param>
        /// <param name="header">パケットヘッダ</param>
        public override void Read(ProtocolSoundReader reader, CommPacketHeader header)
        {
            _received = true;

            uint count = reader.ReadUInt32();

            // プレビュープレイヤー情報を解析する
            for (uint i = 0; i < count; i++)
            {
                SoundHandleState state = (SoundHandleState)reader.ReadUInt32();

                if (UpdateSoundHandleCallbackDelegate != null)
                {
                    UpdateSoundHandleCallbackDelegate(i, state);
                }
            }
        }
    }
}
