﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using NintendoWare.SoundFoundation.Commands;

namespace NintendoWare.SoundMaker.Framework.Windows
{
    public delegate void CommandKeyProcessEventHandler(object sender, CommandKeyProcessEventArgs e);

    /// <summary>
    /// コマンドキーイベントデータを格納します。
    /// </summary>
    public class CommandKeyProcessEventArgs : EventArgs
    {
        private KeyStroke _firstKey;
        private KeyStroke _secondKey;
        private Command _command;

        public CommandKeyProcessEventArgs(KeyStroke firstKey, KeyStroke secondKey,
                                           Command command)
        {
            if (null == firstKey) { throw new ArgumentNullException("firstKey"); }
            if (null == secondKey) { throw new ArgumentNullException("secondKey"); }

            _firstKey = firstKey;
            _secondKey = secondKey;
            _command = command;
        }

        public KeyStroke FirstKey
        {
            get { return _firstKey; }
        }

        public KeyStroke SecondKey
        {
            get { return _secondKey; }
        }

        public Command Command
        {
            get { return _command; }
        }
    }
}
