﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System.Drawing;
    using System.Windows.Forms;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Windows.Forms;
    using NintendoWare.SoundMaker.Framework.Resources;

    public partial class ProjectTreePanel : DockingPage, IToolWindowPage, ICommandTarget
    {
        #region ** 固定値

        public const string PageName = "ProjectTree";

        #endregion

        public ProjectTreePanel() : base(PageName)
        {
            InitializeComponent();

            // テキストとアイコンをロードする
            Bitmap icon = ImageResource.BitmapIconProjectTreeWindow;
            icon.MakeTransparent(UIServiceBase.TransparentColor);

            Text = MessageResource.ToolWindowName_ProjectTree;
            Image = icon;

            // 初期配置を設定する
            FloatingBounds = new Rectangle(-1, -1,
                                            Width + (SystemInformation.FrameBorderSize.Width * 2),
                                            Height + SystemInformation.CaptionHeight + SystemInformation.FrameBorderSize.Height);
        }

        public ProjectPanel ProjectPanel
        {
            get { return _projectPanel; }
        }

        protected override bool Closable
        {
            get { return true; }
        }

        /// <summary>
        /// タイトルを更新します。
        /// </summary>
        public void UpdateTitle()
        {
            Text = MessageResource.ToolWindowName_ProjectTree;

            if (_projectPanel.ReadOnly == true)
            {
                Text += string.Format(" [{0}]", MessageResource.Message_ReadOnly);
            }
        }

        /// <summary>
        /// 指定コマンドを処理するコマンドターゲットを検索します。
        /// </summary>
        /// <param name="command">処理するコマンド。</param>
        /// <returns>コマンドターゲット。</returns>
        ICommandTarget ICommandTarget.FindTarget(Command command)
        {
            return (_projectPanel as ICommandTarget).FindTarget(command);
        }

        /// <summary>
        /// 指定コマンドを実行できるかどうか調べます。
        /// </summary>
        /// <param name="command">実行するコマンド。</param>
        /// <returns>コマンドの状態。</returns>
        CommandStatus ICommandTarget.QueryStatus(Command command)
        {
            return (_projectPanel as ICommandTarget).QueryStatus(command);
        }

        /// <summary>
        /// 指定コマンドを実行します。
        /// </summary>
        /// <param name="command">実行するコマンド。</param>
        bool ICommandTarget.Execute(Command command)
        {
            return (_projectPanel as ICommandTarget).Execute(command);
        }

        protected override bool IsEnableDockingState(DockingPageState state)
        {
            return true;
        }
    }
}
