﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Drawing;
using System.ComponentModel;
using System.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using NintendoWare.SoundFoundation.Core.Drawing;
    using NintendoWare.SoundFoundation.Windows.Forms;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.CommandHandlers;
    using NintendoWare.SoundFoundation.Documents;
    using NintendoWare.SoundFoundation.Operations;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Framework.CommandHandlers;
    using NintendoWare.SoundMaker.Framework.Commands;
    using NintendoWare.SoundMaker.Framework.Resources;

    /// <summary>
    /// パラメータパネル
    /// </summary>
    public partial class ParameterPanel : DockingPageWithCommandTarget, IToolWindowPage, IKeyPreviewReceiver
    {
        #region Windows フォーム デザイナで生成されたコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(ParameterPanel));
            this.instrumentParameterPanel = new NintendoWare.SoundMaker.Framework.Windows.Forms.InstrumentParameterPanel();
            this.soundParameterPanel = new NintendoWare.SoundMaker.Framework.Windows.Forms.SoundParameterPanel();
            this.SuspendLayout();
            //
            // instrumentParameterPanel
            //
            resources.ApplyResources(this.instrumentParameterPanel, "instrumentParameterPanel");
            this.instrumentParameterPanel.MinimumSize = new System.Drawing.Size(435, 480);
            this.instrumentParameterPanel.Name = "instrumentParameterPanel";
            //
            // soundParameterPanel
            //
            resources.ApplyResources(this.soundParameterPanel, "soundParameterPanel");
            this.soundParameterPanel.Name = "soundParameterPanel";
            //
            // ParameterPanel
            //
            resources.ApplyResources(this, "$this");
            this.Controls.Add(this.soundParameterPanel);
            this.Controls.Add(this.instrumentParameterPanel);
            this.Name = "ParameterPanel";
            this.ResumeLayout(false);

        }
        #endregion

        private InstrumentParameterPanel instrumentParameterPanel;
        private SoundParameterPanel soundParameterPanel;
    }
}
