﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Data;
    using System.Drawing;
    using System.Text;
    using System.Windows.Forms;
    using System.IO;
    using Framework.Resources;
    using SoundFoundation.Projects;

    public partial class SoundListOutputSettingListEditDialog : Form
    {
        private List<SoundListOutput> mSoundListOutputSettingList;
        public string ProjectFilePath;

        public SoundListOutputSettingListEditDialog()
        {
            InitializeComponent();
        }

        public List<SoundListOutput> SoundListOutputSettingList
        {
            get { return mSoundListOutputSettingList; }
            set
            {
                mSoundListOutputSettingList = value;

                mList.Items.Clear();
                foreach (SoundListOutput setting in mSoundListOutputSettingList)
                {
                    mList.Items.Add(setting.Name);
                }
                UpdateButtonStatus();
            }
        }

        private string CreateUniqueSettingName(string prefix)
        {
            int index = 1;
            while (true)
            {
                bool flag = true;
                string name = prefix + index.ToString();
                foreach (SoundListOutput setting in mSoundListOutputSettingList)
                {
                    if (name == setting.Name)
                    {
                        flag = false;
                        break;
                    }
                }
                if (flag) return name;
                index++;
            }
            //            return String.Empty;
        }

        private void mNewButton_Click(object sender, EventArgs e)
        {
            SoundListOutputSettingCreateDialog dialog = new SoundListOutputSettingCreateDialog(ProjectFilePath);

            string settingName = CreateUniqueSettingName("Setting ");
            string outputFileName = String.Format
                ("{0}_{1}", Path.GetFileNameWithoutExtension(ProjectFilePath), settingName);
            string outputFilePath = Path.ChangeExtension(outputFileName, ".html");

            dialog.SettingName = settingName;
            dialog.OutputFilePath = outputFilePath;

            if (dialog.ShowDialog(this) == DialogResult.OK)
            {
                SoundListOutput setting = dialog.NewSoundListOutput(
                    Path.GetFileNameWithoutExtension(this.ProjectFilePath));

                mSoundListOutputSettingList.Add(setting);

                int index = mList.Items.Add(setting.Name);
                mList.SelectedIndex = index;
            }
        }

        private void mCopyButton_Click(object sender, EventArgs e)
        {
            int index = mList.SelectedIndex;
            if (index < 0 || index > mSoundListOutputSettingList.Count - 1) return;

            SoundListOutput setting = mSoundListOutputSettingList[index];
            SoundListOutput newSetting = setting.Clone();

            index++;

            mSoundListOutputSettingList.Insert(index, newSetting);
            mList.Items.Insert(index, newSetting.Name);
            mList.SelectedIndex = index;
        }

        private void mDeleteButton_Click(object sender, EventArgs e)
        {
            int index = mList.SelectedIndex;
            if (index < 0 || index > mSoundListOutputSettingList.Count - 1) return;

            string message = String.Format(
                MessageResource.Message_ConfirmRemoveSettings,
                mSoundListOutputSettingList[index].Name);
            if (MessageBox.Show(
                     this,
                     message,
                     MessageResource.MessageCaption_ConfirmRemoveSettings,
                     MessageBoxButtons.YesNo
                 ) == DialogResult.Yes)
            {
                mSoundListOutputSettingList.RemoveAt(index);
                mList.Items.RemoveAt(index);
                if (index < mSoundListOutputSettingList.Count)
                {
                    mList.SelectedIndex = index;
                }
                else if (mSoundListOutputSettingList.Count > 0)
                {
                    mList.SelectedIndex = mSoundListOutputSettingList.Count - 1;
                }
            }
        }

        private void mList_SelectedIndexChanged(object sender, EventArgs e)
        {
            UpdateButtonStatus();
        }

        private void UpdateButtonStatus()
        {
            bool isSelect = mList.SelectedIndex >= 0;
            mDeleteButton.Enabled = isSelect ? true : false;
            mCopyButton.Enabled = isSelect ? true : false;
            mChangeNameButton.Enabled = isSelect ? true : false;

            mMoveUpButton.Enabled = isSelect && mList.SelectedIndex > 0;
            mMoveDownButton.Enabled = isSelect && mList.SelectedIndex < mList.Items.Count - 1;
        }

        private void MoveItem(int diff)
        {
            int index = mList.SelectedIndex;
            if (index < 0 || index > mSoundListOutputSettingList.Count - 1) return;

            SoundListOutput setting = mSoundListOutputSettingList[index];
            mSoundListOutputSettingList.RemoveAt(index);
            mList.Items.RemoveAt(index);

            index += diff;

            mSoundListOutputSettingList.Insert(index, setting);
            mList.Items.Insert(index, setting.Name);

            mList.SelectedIndex = index;

        }

        private void mMoveUpButton_Click(object sender, EventArgs e)
        {
            MoveItem(-1);
        }

        private void mMoveDownButton_Click(object sender, EventArgs e)
        {
            MoveItem(+1);
        }

        private void mChangeNameButton_Click(object sender, EventArgs e)
        {
            int index = mList.SelectedIndex;

            if (index < 0 || index > mSoundListOutputSettingList.Count - 1) return;
            SoundListOutput setting = mSoundListOutputSettingList[index];

            SoundListOutputSettingNameChangeDialog dialog = new SoundListOutputSettingNameChangeDialog();
            dialog.SettingName = setting.Name;

            if (dialog.ShowDialog() == DialogResult.OK)
            {
                setting.Name = dialog.SettingName;
                mList.Items[index] = dialog.SettingName;
            }
        }

    }
}
