﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Data;
    using System.Drawing;
    using System.Linq;
    using System.Text;
    using System.Text.RegularExpressions;
    using System.Windows.Forms;

    using NintendoWare.SoundFoundation.Projects;

    public partial class UserDataEditDialog2 : Form
    {
        private ulong value = 0;

        /// <summary>
        ///
        /// </summary>
        public UserDataEditDialog2()
        {
            InitializeComponent();
            this.Shown += this.OnShown;
        }

        /// <summary>
        /// 値の取得
        /// </summary>
        public ulong Value
        {
            get
            {
                return GetCombinedValue();
            }
            set
            {
                this.value = value;
            }
        }

        /// <summary>
        ///
        /// </summary>
        private UserParameterStructureSetting userDataStructureSetting = null;
        public UserParameterStructureSetting UserDataStructureSetting
        {
            set
            {
                this.userDataStructureSetting = value;
                UpdateControls();
            }
        }

        /// <summary>
        ///
        /// </summary>
        private ulong GetCombinedValue()
        {
            ulong result = 0;

            foreach (IPartialValueManipulator manipulator in this.flowLayoutPanel.Controls)
            {
                result |= manipulator.GetPartialValue();
            }

            return result;
        }

        /// <summary>
        ///
        /// </summary>
        private UserDataPanel.Candidate[] GetCandidate(UserParameterStructure structure)
        {
            return UserParameterUtility
                .GetValueCandidate(structure)
                .Select(p => new UserDataPanel.Candidate() { Label = p.Value, Value = p.Key })
                .ToArray();
        }

        /// <summary>
        ///
        /// </summary>
        private void UpdateControls()
        {
            if (this.userDataStructureSetting == null)
            {
                return;
            }

            this.flowLayoutPanel.Controls.Clear();
            int totalHeight = 0;

            foreach (UserParameterStructure structure in this.userDataStructureSetting.Structures)
            {
                switch (structure.StructureType)
                {
                    case StructureTypes.Integer:
                        {
                            int value = UserParameterUtility.GetPartialIntegerValue(structure,
                                                                                    this.value);
                            UserDataPanel.Candidate[] candidates = GetCandidate(structure);

                            UserDataIntegerPanel panel = new UserDataIntegerPanel();
                            panel.Label = structure.Label;
                            panel.BitLocation = structure.Location;
                            panel.BitSize = structure.Size;
                            panel.Candidates = candidates;
                            panel.Value = value;
                            panel.ValueChanged += OnValueChanged;

                            this.flowLayoutPanel.Controls.Add(panel);
                            totalHeight += panel.Height;
                        }
                        break;

                    case StructureTypes.UInteger:
                        {
                            ulong value = UserParameterUtility.GetPartialUIntegerValue(structure,
                                                                                          this.value);
                            UserDataPanel.Candidate[] candidates = GetCandidate(structure);

                            UserDataUIntegerPanel panel = new UserDataUIntegerPanel();
                            panel.Label = structure.Label;
                            panel.BitLocation = structure.Location;
                            panel.BitSize = structure.Size;
                            panel.Candidates = candidates;
                            panel.Value = value;
                            panel.ValueChanged += OnValueChanged;

                            this.flowLayoutPanel.Controls.Add(panel);
                            totalHeight += panel.Height;
                        }
                        break;

                    case StructureTypes.Decimal:
                        {
                            float value = UserParameterUtility.GetPartialDecimalValue(structure,
                                                                                      this.value);
                            UserDataPanel.Candidate[] candidates = GetCandidate(structure);

                            UserDataDecimalPanel panel = new UserDataDecimalPanel();
                            panel.Label = structure.Label;
                            panel.BitLocation = structure.Location;
                            panel.BitSize = structure.Size;
                            panel.Candidates = candidates;
                            panel.Value = value;
                            panel.ValueChanged += OnValueChanged;

                            this.flowLayoutPanel.Controls.Add(panel);
                            totalHeight += panel.Height;
                        }
                        break;

                    case StructureTypes.Boolean:
                        {
                            bool value = UserParameterUtility.GetPartialBooleanValue(structure,
                                                                                     this.value);

                            UserDataBooleanPanel panel = new UserDataBooleanPanel();
                            panel.Label = structure.Label;
                            panel.BitLocation = structure.Location;
                            panel.BitSize = structure.Size;
                            panel.Value = value;

                            this.flowLayoutPanel.Controls.Add(panel);
                            totalHeight += panel.Height;
                        }
                        break;
                }
            }

            int ncHeight = Size.Height - ClientRectangle.Height;
            int cHeight = ClientRectangle.Height - this.flowLayoutPanel.Height;
            this.Height = totalHeight + ncHeight + cHeight;
        }

        private void OnShown(object sender, EventArgs e)
        {
            if (this.button_OK.Focus() == true) return;
        }

        private void OnValueChanged(object sender, EventArgs e)
        {
            foreach (Control crtl in this.flowLayoutPanel.Controls)
            {
                if (crtl is UserDataPanel)
                {
                    UserDataPanel panel = crtl as UserDataPanel;
                    if (panel.ValidateValue == false)
                    {
                        this.button_OK.Enabled = false;
                        return;
                    }
                }
            }

            this.button_OK.Enabled = true;
            return;
        }
    }

    ///
    public interface IPartialValueManipulator
    {
        ulong GetPartialValue();
    }
}
