﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Windows.Forms;
using NintendoWare.SoundFoundation.Projects;
using NintendoWare.SoundMaker.Framework.Resources;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    ///--------------------------------------------------------------------------
    /// <summary>
    ///
    /// </summary>
    public partial class GroupItemEntryDialog : Form
    {

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public GroupItemEntryDialog(GroupRegisteredState[] states, Component[] components)
        {
            InitializeComponent();

            //
            string message = null;

            if (components.Length == 1)
            {
                message = String.Format
                    (MessageResource.GroupItemEntryDialogText_SingleEntryMessage,
                      components[0].Name);

            }
            else
            {

                message = String.Format
                    (MessageResource.GroupItemEntryDialogText_MultipleEntryMessage,
                      components[0].Name, components.Length);
            }
            label_Message.Text = message;

            //
            ApplyGroupRegisteredStates(states);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private class Data
        {
            public GroupBase Group { get; set; }

            ///
            public Data(GroupBase group)
            {
                Group = group;
            }

            ///
            public override string ToString()
            {
                return Group.Name;
            }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void ApplyGroupRegisteredStates(GroupRegisteredState[] states)
        {
            CheckState checkState = CheckState.Unchecked;
            Data data = null;

            for (int index = 0; index < states.Length; index++)
            {
                data = new Data(states[index].Group);
                checkedListBox.Items.Add(data);

                switch (states[index].State)
                {
                    case GroupRegisteredState.States.Registered:
                        checkState = CheckState.Checked;
                        break;

                    case GroupRegisteredState.States.Intermingled:
                        checkState = CheckState.Indeterminate;
                        break;

                    case GroupRegisteredState.States.Unregistered:
                        checkState = CheckState.Unchecked;
                        break;

                    default:
                        Debug.Assert(false, "It is not an effective choice");
                        break;
                }

                checkedListBox.SetItemCheckState(index, checkState);
            }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public GroupRegisteredState[] GetGroupRegisteredStates()
        {
            List<GroupRegisteredState> list = new List<GroupRegisteredState>();
            GroupRegisteredState state = null;
            Data data = null;
            CheckState checkState;

            for (int index = 0; index < checkedListBox.Items.Count; index++)
            {
                checkState = checkedListBox.GetItemCheckState(index);
                data = checkedListBox.Items[index] as Data;
                Debug.Assert(data != null, "data is not null");

                if (checkState != CheckState.Indeterminate)
                {
                    state = new GroupRegisteredState();
                    state.Group = data.Group;

                    switch (checkState)
                    {
                        case CheckState.Checked:
                            state.State = GroupRegisteredState.States.Registered;
                            break;

                        case CheckState.Unchecked:
                            state.State = GroupRegisteredState.States.Unregistered;
                            break;

                        default:
                            Debug.Assert(false, "It is not an effective choice");
                            break;
                    }

                    list.Add(state);
                }
            }

            return list.ToArray();
        }

        ///--------------------------------
        /// <summary>
        /// ウインドウの位置が変更された時に呼ばれる
        /// </summary>
        private void OnMove(object sender, EventArgs e)
        {
        }

        ///--------------------------------
        /// <summary>
        /// ウインドウのサイズが変更された時に呼ばれる
        /// </summary>
        private void OnResize(object sender, EventArgs e)
        {
        }
    }


    ///--------------------------------------------------------------------------
    /// <summary>
    ///
    /// </summary>
    public class GroupRegisteredState
    {

        public enum States
        {
            Unregistered,
            Registered,
            Intermingled,
        }

        public States State { get; set; }
        public GroupBase Group { get; set; }

        public GroupRegisteredState()
        {
            State = States.Unregistered;
            Group = null;
        }
    }
}
