﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.Diagnostics;
using NintendoWare.SoundFoundation.Core;
using NintendoWare.SoundFoundation.Core.Parameters;
using NintendoWare.SoundMaker.Framework.Resources;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    /// <summary>
    /// ProjectCreatePageName の概要の説明です。
    /// </summary>
    public class ProjectCreatePageName : ProjectCreatePage, IWizardPage
    {
        private System.Windows.Forms.Button button_Reference;
        private System.Windows.Forms.Label label_Path;
        private System.Windows.Forms.TextBox textBox_Name;
        private System.Windows.Forms.Label label_Name;
        private System.Windows.Forms.GroupBox groupBox_SoundSet;
        private System.Windows.Forms.RadioButton radioButton_CreateSoundSet;
        private System.Windows.Forms.RadioButton radioButton_SpecifySoundSet;
        private System.Windows.Forms.RadioButton radioButton_Nothing;

        /// <summary>
        /// 必要なデザイナ変数です。
        /// </summary>
        private System.ComponentModel.Container components = null;
        private System.Windows.Forms.TextBox textBox_Directory;

        ///--------------------------------
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ProjectCreatePageName()
        {
            InitializeComponent();
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        void IWizardPage.PreShow()
        {
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        bool IWizardPage.OnBack()
        {
            return false;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        string IWizardPage.OnNext()
        {
            bool name = InspectName();
            bool directory = InspectDirectory();

            if (name == false ||
                    directory == false)
            {
                return null;
            }

            //
            if (File.Exists(ProjectFilePath) != false)
            {
                if (FormsApplication.Instance.UIService.ShowMessageBox(MessageResource.Message_ConfirmOverwriteProjectFile,
                            AppMessageBoxButton.YesNo, AppMessageBoxImage.Warning) != AppMessageBoxResult.Yes)
                {
                    return null;
                }
            }

            //
            if (radioButton_CreateSoundSet.Checked != false)
            {

                //
                if (File.Exists(SoundSetFilePath) != false)
                {
                    if (FormsApplication.Instance.UIService.ShowMessageBox(MessageResource.Message_ConfirmOverwriteSoundSetFile,
                                AppMessageBoxButton.YesNo, AppMessageBoxImage.Warning) != AppMessageBoxResult.Yes)
                    {
                        return null;
                    }
                }

                return "Finish";
            }

            if (radioButton_SpecifySoundSet.Checked != false)
            {
                return "SpecifySoundSet";
            }

            if (radioButton_Nothing.Checked != false)
            {
                return "Finish";
            }

            return null;
        }

        ///--------------------------------
        /// <summary>
        /// 名前の検査
        /// </summary>
        private bool InspectName()
        {
            string name = textBox_Name.Text;

            if (name == String.Empty)
            {
                ShowError(textBox_Name, MessageResource.Message_InputFileName);
                return false;
            }

            ValidationResult result = FilePathValidator.ValidateFileName(name);
            if (!result.IsValid)
            {
                ShowError(textBox_Name, result.ToString());
                return false;
            }

            HideError(textBox_Name);
            return true;
        }

        ///--------------------------------
        /// <summary>
        /// ディレクトリの検査
        /// </summary>
        private bool InspectDirectory()
        {
            string directory = textBox_Directory.Text;

            if (directory == String.Empty)
            {
                ShowError(textBox_Directory, MessageResource.Message_InputPath);
                return false;
            }

            if (Directory.Exists(directory) == false)
            {
                ShowError(textBox_Directory, MessageResource.Message_DirectoryNotFound);
                return false;
            }

            HideError(textBox_Directory);
            return true;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        bool IWizardPage.OnFinish() { return false; }
        bool IWizardPage.QueryFinishPage() { return false; }

        ///--------------------------------
        /// <summary>
        /// サウンドセットを作成するのか調べる
        /// </summary>
        public bool DoCreateSoundSet
        {
            get { return radioButton_CreateSoundSet.Checked; }
        }

        ///--------------------------------
        /// <summary>
        /// サウンドセットを指定するのか調べる
        /// </summary>
        public bool DoSpecifySoundSet
        {
            get { return radioButton_SpecifySoundSet.Checked; }
        }

        ///--------------------------------
        /// <summary>
        /// プロジェクトファイルのパスの取得
        /// </summary>
        public string ProjectFilePath
        {
            get
            {
                return ProjectFileQuester.CreateFilePath
                    (textBox_Directory.Text, textBox_Name.Text);
            }
        }

        ///--------------------------------
        /// <summary>
        /// サウンドセットファイルのパスの取得
        /// </summary>
        public string SoundSetFilePath
        {
            get
            {
                return SoundSetFileQuester.CreateFilePath
                    (textBox_Directory.Text, textBox_Name.Text);
            }
        }


        ///--------------------------------
        /// <summary>
        /// 使用されているリソースに後処理を実行します。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region コンポーネント デザイナで生成されたコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(ProjectCreatePageName));
            this.button_Reference = new System.Windows.Forms.Button();
            this.label_Path = new System.Windows.Forms.Label();
            this.textBox_Directory = new System.Windows.Forms.TextBox();
            this.textBox_Name = new System.Windows.Forms.TextBox();
            this.label_Name = new System.Windows.Forms.Label();
            this.radioButton_CreateSoundSet = new System.Windows.Forms.RadioButton();
            this.groupBox_SoundSet = new System.Windows.Forms.GroupBox();
            this.radioButton_Nothing = new System.Windows.Forms.RadioButton();
            this.radioButton_SpecifySoundSet = new System.Windows.Forms.RadioButton();
            this.groupBox_SoundSet.SuspendLayout();
            this.SuspendLayout();
            //
            // button_Reference
            //
            resources.ApplyResources(this.button_Reference, "button_Reference");
            this.button_Reference.Name = "button_Reference";
            this.button_Reference.Click += new System.EventHandler(this.OnReferencePath);
            //
            // label_Path
            //
            resources.ApplyResources(this.label_Path, "label_Path");
            this.label_Path.Name = "label_Path";
            //
            // textBox_Directory
            //
            resources.ApplyResources(this.textBox_Directory, "textBox_Directory");
            this.textBox_Directory.Name = "textBox_Directory";
            //
            // textBox_Name
            //
            resources.ApplyResources(this.textBox_Name, "textBox_Name");
            this.textBox_Name.Name = "textBox_Name";
            //
            // label_Name
            //
            resources.ApplyResources(this.label_Name, "label_Name");
            this.label_Name.Name = "label_Name";
            //
            // radioButton_CreateSoundSet
            //
            resources.ApplyResources(this.radioButton_CreateSoundSet, "radioButton_CreateSoundSet");
            this.radioButton_CreateSoundSet.Checked = true;
            this.radioButton_CreateSoundSet.Name = "radioButton_CreateSoundSet";
            this.radioButton_CreateSoundSet.TabStop = true;
            //
            // groupBox_SoundSet
            //
            this.groupBox_SoundSet.Controls.Add(this.radioButton_Nothing);
            this.groupBox_SoundSet.Controls.Add(this.radioButton_SpecifySoundSet);
            this.groupBox_SoundSet.Controls.Add(this.radioButton_CreateSoundSet);
            resources.ApplyResources(this.groupBox_SoundSet, "groupBox_SoundSet");
            this.groupBox_SoundSet.Name = "groupBox_SoundSet";
            this.groupBox_SoundSet.TabStop = false;
            //
            // radioButton_Nothing
            //
            resources.ApplyResources(this.radioButton_Nothing, "radioButton_Nothing");
            this.radioButton_Nothing.Name = "radioButton_Nothing";
            //
            // radioButton_SpecifySoundSet
            //
            resources.ApplyResources(this.radioButton_SpecifySoundSet, "radioButton_SpecifySoundSet");
            this.radioButton_SpecifySoundSet.Name = "radioButton_SpecifySoundSet";
            //
            // ProjectCreatePageName
            //
            this.Controls.Add(this.groupBox_SoundSet);
            this.Controls.Add(this.button_Reference);
            this.Controls.Add(this.label_Path);
            this.Controls.Add(this.textBox_Directory);
            this.Controls.Add(this.textBox_Name);
            this.Controls.Add(this.label_Name);
            this.Name = "ProjectCreatePageName";
            resources.ApplyResources(this, "$this");
            this.groupBox_SoundSet.ResumeLayout(false);
            this.groupBox_SoundSet.PerformLayout();
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        #endregion


        ///--------------------------------
        /// <summary>
        /// パスの参照
        /// </summary>
        private void OnReferencePath(object sender, System.EventArgs e)
        {
            FolderBrowserDialog dialog = new FolderBrowserDialog();
            if (dialog.ShowDialog() != DialogResult.OK)
            {
                return;
            }

            textBox_Directory.Text = dialog.SelectedPath;
        }
    }
}
