﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Resources;
using System.Reflection;
using System.Diagnostics;
using NintendoWare.SoundFoundation.Core;
using NintendoWare.SoundFoundation.Projects;
using NintendoWare.SoundMaker.Framework.Resources;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    ///--------------------------------------------------------------------------
    /// <summary>
    /// CreatePlayerDialog の概要の説明です。
    /// </summary>
    public partial class CreatePlayerDialog : CreateSoundSetItemDialog
    {

        private readonly PlayerBase _player = ApplicationBase.Instance.CreateComponentService.Create<PlayerBase>();

        ///--------------------------------
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public CreatePlayerDialog(SoundProjectService projectService) : base(projectService)
        {
            InitializeComponent();

            //
            SetUniqueNameToTextBox(textBox_Label, projectService.Project,
                                    ProjectService.ComponentDictionary,
                                    ProjectService.Project.PlayerNamePrefix);

            //
            this.SoundLimit = _player.SoundLimit;
            this.HeapSize = _player.HeapSize;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private string Label
        {
            get { return textBox_Label.Text; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private int SoundLimit
        {
            get
            {
                return int.Parse(textBox_SoundLimit.Text);
            }
            set
            {
                textBox_SoundLimit.Text = value.ToString();
            }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private int HeapSize
        {
            get
            {
                return int.Parse(textBox_HeapSize.Text);
            }
            set
            {
                textBox_HeapSize.Text = value.ToString();
            }
        }

        /// <summary>
        /// 作成したプレイヤーを取得します。
        /// </summary>
        public PlayerBase Player
        {
            get
            {
                _player.Name = Label;
                _player.SoundLimit = SoundLimit;
                _player.HeapSize = HeapSize;

                return _player;
            }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override bool CanCreate
        {
            get
            {
                try
                {
                    bool label = InspectLabel();
                    bool soundLimit = InspectSoundLimit();
                    bool heapSize = InspectHeapSize();

                    if (label != false &&
                        soundLimit != false &&
                        heapSize != false)
                    {
                        return true;
                    }
                }
                catch { }
                return false;
            }
        }

        ///--------------------------------
        /// <summary>
        /// ラベルの検査
        /// </summary>
        private bool InspectLabel()
        {
            return ValidateName(textBox_Label.Text, textBox_Label);
        }

        ///--------------------------------
        /// <summary>
        /// サウンドリミットの検査
        /// </summary>
        private bool InspectSoundLimit()
        {
            return ValidateIntParameter(_player, ProjectParameterNames.Player.SoundLimit,
                                        textBox_SoundLimit.Text, textBox_SoundLimit);
        }

        ///--------------------------------
        /// <summary>
        /// ヒープサイズの検査
        /// </summary>
        private bool InspectHeapSize()
        {
            return ValidateIntParameter(_player, ProjectParameterNames.Player.HeapSize,
                                        textBox_HeapSize.Text, textBox_HeapSize);
        }

        ///--------------------------------
        /// <summary>
        /// 確定に使用するボタンの取得
        /// </summary>
        protected override Control GetAcceptButton()
        {
            return button_OK;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void OnTextChanged(object sender, System.EventArgs e)
        {
            UpdateControls();
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void OnValidatedLabel(object sender, System.EventArgs e)
        {
            InspectLabel();
            UpdateControls();
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void OnValidatedSoundLimit(object sender, System.EventArgs e)
        {
            InspectSoundLimit();
            UpdateControls();
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private void OnValidatedHeapSize(object sender, System.EventArgs e)
        {
            InspectHeapSize();
            UpdateControls();
        }
    }
}
