﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    /// <summary>
    ///
    /// </summary>
    public partial class UnhandledExceptionDialog : Form
    {
        /// <summary>
        ///
        /// </summary>
        public UnhandledExceptionDialog()
        {
            InitializeComponent();
        }

        /// <summary>
        ///
        /// </summary>
        public string Message
        {
            get
            {
                return this.tbx_Message.Text;
            }
            set
            {
                this.tbx_Message.Text = value;
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void OnClose(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
        }

        /// <summary>
        ///
        /// </summary>
        private void OnSend(object sender, EventArgs e)
        {
            StringBuilder sb = new StringBuilder();

            if (UnhandleExceptionHelper.MailAddresses.Length <= 0)
            {
                return;
            }

            //
            string[] addresses = UnhandleExceptionHelper.MailAddresses;
            string address = addresses[0];
            for (int index = 1; index < addresses.Length; index++)
            {
                address += String.Format(",{0}", addresses[index]);
            }

            string to = String.Format("mailto:{0}?", address);
            sb.Append(to);

            string subject = "[ErrorReport][SoundMaker]UnhandleException";
            sb.Append(String.Format("subject={0}", subject));


            Tuple<string, string>[] replaceCharacters = new Tuple<string, string>[] {
                new Tuple<string,string>( "%", "%25"),
                new Tuple<string,string>( "\r", "%0D"),
                new Tuple<string,string>( "\n", "%0A"),
                new Tuple<string,string>( "?", "%3F"),
                new Tuple<string,string>( "&", "%26"),
                new Tuple<string,string>( ",", "%2C"),
                new Tuple<string,string>( ";", "%3B"),
                new Tuple<string,string>( "\"", "%22"),
            };

            string message = Message;
            foreach (Tuple<string, string> replaceCharacter in replaceCharacters)
            {
                message = message.Replace(replaceCharacter.Item1,
                                           replaceCharacter.Item2);
            }

            string body = String.Format("&body={0}", message);
            sb.Append(body);

            Process.Start(sb.ToString());
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class UnhandleExceptionHelper
    {
        /// <summary>
        ///
        /// </summary>
        public static bool ShowDialog
        {
            get;
            set;
        }

        /// <summary>
        ///
        /// </summary>
        public static string[] MailAddresses
        {
            get;
            set;
        }

        /// <summary>
        ///
        /// </summary>
        public static void Initialize()
        {
            string directory = Path.GetDirectoryName(Application.ExecutablePath);

            string fileName = Path.GetFileNameWithoutExtension(Application.ExecutablePath);
            fileName += "_enable_mail";

            string filePath = Path.Combine(directory, fileName);
            if (File.Exists(filePath) != false)
            {
                using (StreamReader reader = new StreamReader(filePath))
                {
                    string text = reader.ReadToEnd();

                    char[] delimiters = new char[] { '\r', '\n' };
                    string[] addresses = text.Split
                        (delimiters, StringSplitOptions.RemoveEmptyEntries);

                    MailAddresses = addresses;
                }

                ShowDialog = true;
            }
        }
    }
}
