﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using NintendoWare.SoundFoundation.Core.Parameters;

    public class IntLabelParameterValue : IntParameterValue
    {
        private Dictionary<int, string> labelDictionary = new Dictionary<int, string>();

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public IntLabelParameterValue()
            : base()
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="value">パラメータの値を指定します。</param>
        public IntLabelParameterValue(int value)
            : base(value)
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="value">パラメータの値を指定します。</param>
        /// <param name="min">最小値を指定します。</param>
        /// <param name="max">最大値を指定します。</param>
        public IntLabelParameterValue(int value, int min, int max)
            : base(value, min, max)
        {
        }

        /// <summary>
        /// int の値に対応するラベルの辞書です。
        /// </summary>
        public Dictionary<int, string> LabelDictionary
        {
            get { return this.labelDictionary; }
        }

        public override string ToString()
        {
            if (this.labelDictionary.ContainsKey(this.Value) == true)
            {
                return this.labelDictionary[this.Value];
            }
            else
            {
                return base.ToString();
            }
        }

        protected override int ParseInternal(string text)
        {
            foreach (int key in this.labelDictionary.Keys)
            {
                if (this.labelDictionary[key] == text)
                {
                    return key;
                }
            }

            return base.ParseInternal(text);
        }
    }
}
