﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Drawing;
    using System.Drawing.Imaging;
    using System.IO;
    using System.Linq;
    using System.Security.Cryptography;
    using System.Windows.Forms;
    using System.Windows.Forms.VisualStyles;
    using NintendoWare.SoundFoundation.CommandHandlers;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Core.Parameters;
    using NintendoWare.SoundFoundation.Documents;
    using NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate;
    using NintendoWare.SoundFoundation.FileFormats.Wave;
    using NintendoWare.SoundFoundation.Operations;
    using NintendoWare.SoundFoundation.Parameters;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundFoundation.Windows.Forms;
    using NintendoWare.SoundMaker.Framework.CommandHandlers;
    using NintendoWare.SoundMaker.Framework.Commands;
    using NintendoWare.SoundMaker.Framework.Configurations;
    using NintendoWare.SoundMaker.Framework.Configurations.Schemas;
    using NintendoWare.SoundMaker.Framework.FileFormats;
    using NintendoWare.SoundMaker.Framework.Resources;
    using NintendoWare.ToolDevelopmentKit.Collections;
    using SFresrc = NintendoWare.SoundFoundation.Resources;

    /// <summary>
    ///
    /// </summary>
    public class CommonTabPage : NTabPage
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public CommonTabPage()
        {
            SelectOnVisible = false;
        }

        /// <summary>
        ///
        /// </summary>
        public CommonPanel Panel
        {
            get
            {
                CommonPanel panel = null;

                if (Controls.Count <= 0)
                {
                    return null;
                }

                panel = Controls[0] as CommonPanel;
                Debug.Assert(panel != null, "panel is not PanelBase");
                return panel;
            }
        }

        /// <summary>
        ///
        /// </summary>
        public override void Select()
        {
            if (Panel.ContainsFocus)
            {
                return;
            }

            Panel.ActivatePanel(false, true);
        }

        /// <summary>
        ///
        /// 戻り値が falseの時には閉じる処理がキャンセルされる
        /// </summary>
        public bool Closing()
        {
            return Panel.OnClosing();
        }

        /// <summary>
        ///
        /// </summary>
        public void Closed()
        {
            Panel.OnClosed();
        }
    }
}
