﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using NintendoWare.SoundFoundation.Operations;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundFoundation.Windows.Forms;

    public class SampleMapAdapter : ComponentSampleMapAdapter, IAdapterManipulator
    {
        private Dictionary<string, SetValueHandler> setterDictionary =
            new Dictionary<string, SetValueHandler>();

        /// <summary>
        ///
        /// </summary>
        public Dictionary<string, SetValueHandler> Setters
        {
            get
            {
                return this.setterDictionary;
            }
        }

        /// <summary>
        ///
        /// </summary>
        void IAdapterManipulator.OperationExecuted(Operation operation)
        {
            OnOperationExecuted(operation);
        }

        /// <summary>
        ///
        /// </summary>
        void IAdapterManipulator.Set(Component component, string name, object value)
        {
            base.SetValue(component, name, value);
        }

        /// <summary>
        ///
        /// </summary>
        public override void SetValue(Component component, string name, object value)
        {
            if (component.Parameters.ContainsKey(name) == false)
            {
                return;
            }

            if (this.setterDictionary.ContainsKey(name) == true)
            {
                if (this.setterDictionary[name](this, component, name, value) == true)
                {
                    return;
                }
            }

            base.SetValue(component, name, value);
        }
    }
}
