﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows.Forms;
using NintendoWare.SoundFoundation.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    ///--------------------------------------------------------------------------
    /// <summary>
    /// パーカッションリストヘッダアダプタ
    /// </summary>
    public class PercussionListHeaderAdapter : ListHeaderAdapterBase
    {
        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override void SetRowHeaderColumn()
        {
            ComponentHeaderItem item = null;

            item = new ComponentHeaderItem("Key");
            item.Text = String.Empty;
            item.SortOrders.Clear();
            item.SortOrders.Add(SortOrder.None);
            item.Type = HeaderItemType.LeftFixed;
            item.Length = 64;
            item.MinimumLength = 64;
            Items.Add(item);
        }
    }
}
