﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NintendoWare.SoundFoundation.CommandHandlers;
using NintendoWare.SoundFoundation.Commands;
using NintendoWare.SoundMaker.Framework.Commands;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms.CommandHandlers
{
    /// <summary>
    /// WindowsForms ベースのアプリケーションを終了します。
    /// </summary>
    public class ExitApplicationHandler : CommandHandler
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="application">アプリケーション。</param>
        public ExitApplicationHandler()
        {
            if (!(ApplicationBase.Instance is FormsApplication))
            {
                throw new Exception("ApplicationBase.Instance must be FormsApplication.");
            }
        }

        /// <summary>
        /// コマンドハンドラが実行可能なコマンドIDを取得します。
        /// </summary>
        public override string TargetCommandID
        {
            get { return FileCommands.ExitApplication.ID; }
        }

        /// <summary>
        /// アプリケーションを取得します。
        /// </summary>
        private FormsApplication Application
        {
            get { return FormsApplication.Instance; }
        }

        /// <summary>
        /// コマンドを実行できるかどうか調べます。
        /// </summary>
        /// <returns>コマンドの状態。</returns>
        protected override CommandStatus QueryStatusInternal(Command command, IQueryCommandParameter parameters)
        {
            return CommandStatus.SupportedAndEnabledAndVisible;
        }

        /// <summary>
        /// コマンドを実行します。
        /// </summary>
        /// <returns>実行した場合は true、実行しなかった、キャンセルした場合は false。</returns>
        protected override bool ExecuteInternal(Command command, IQueryCommandParameter parameters)
        {
            return ExitApplication();
        }

        /// <summary>
        /// アプリケーションを終了します。
        /// </summary>
        /// <returns>実行した場合は true、実行しなかった、キャンセルした場合は false。</returns>
        protected bool ExitApplication()
        {
            return Application.Exit();
        }
    }
}
