﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.SoundFoundation.Commands;
using NintendoWare.SoundFoundation.Projects;
using NintendoWare.SoundFoundation.Windows.Forms;
using NintendoWare.SoundMaker.Framework.CommandHandlers;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms.CommandHandlers
{
    ///--------------------------------------------------------------------------
    /// <summary>
    /// "削除"ハンドラ
    /// </summary>
    public class SoundSetPanelDeleteHandler : DeleteHandler
    {
        private CaretItemSetter _CaretItemSetter = new CaretItemSetter();

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public SoundSetPanelDeleteHandler(IQueryCommandParameter queryParameter)
            : base(queryParameter)
        {
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override CommandStatus QueryStatusInternal(Command command, IQueryCommandParameter parameters)
        {
            Component[] components = GetTargetComponents(parameters);
            if (components == null || components.Length == 0) { return CommandStatus.SupportedAndVisible; }

            if (components[0].Parent is StreamSoundBase &&
                components[0].Parent.Children.Count == components.Length)
            {
                return CommandStatus.SupportedAndVisible;
            }

            return CommandStatus.SupportedAndEnabledAndVisible;
        }

        ///--------------------------------
        /// <summary>
        /// </summary>
        protected override bool ExecuteInternal(Command command, IQueryCommandParameter parameters)
        {
            _CaretItemSetter.PreserveNextItem(parameters);

            if (base.ExecuteInternal(command, parameters) == false)
            {
                return false;
            }

            _CaretItemSetter.SetCaretByPreservedItem(parameters);
            return true;
        }
    }

    /// <summary>
    /// リストの選択状態から次のカレットを設定するクラスです。
    /// </summary>
    public class CaretItemSetter
    {
        public const string CommandParameterOfListCtrl = "ListCtrl";

        private IListItem _NextCaretItem = null;

        public void SetCaretByPreservedItem(IQueryCommandParameter parameters)
        {
            SetCaretByPreservedItem(GetListCtrl(parameters));
        }

        public void SetCaretByPreservedItem(ListCtrl listCtrl)
        {
            if (listCtrl == null || _NextCaretItem == null)
            {
                return;
            }

            listCtrl.SetCaret(_NextCaretItem);
            listCtrl.SetCardinalItemByCaret();
        }

        public void PreserveNextItem(IQueryCommandParameter parameters)
        {
            PreserveNextItem(GetListCtrl(parameters));
        }

        public void PreserveNextItem(ListCtrl listCtrl)
        {
            if (listCtrl == null)
            {
                return;
            }

            _NextCaretItem = GetNextItem(listCtrl);
        }

        private ListCtrl GetListCtrl(IQueryCommandParameter parameters)
        {
            return parameters.GetParameter(CommandParameterOfListCtrl) as ListCtrl;
        }

        private IListItem GetNextItem(IQueryCommandParameter parameters)
        {
            if (!parameters.ContainsParameter(CommandParameterOfListCtrl))
            {
                return null;
            }

            var listCtrl = GetListCtrl(parameters);
            if (listCtrl == null)
            {
                return null;
            }

            return GetNextItem(listCtrl);
        }

        private IListItem GetNextItem(ListCtrl listCtrl)
        {
            var items = listCtrl.SelectedItems;
            if (items.Length == 0)
            {
                return null;
            }

            var item = items[0];
            var baseIndex = listCtrl.ItemsSource.Items.IndexOf(item);
            var selectedItems = listCtrl.GetItemSelecteds();

            var index = baseIndex + 1;
            while (index < listCtrl.ItemsSource.Items.Count)
            {
                item = listCtrl.ItemsSource.Items[index];
                if (selectedItems.Selected(item) == false)
                {
                    return item;
                }
                index++;
            }

            index = baseIndex - 1;
            while (index >= 0)
            {
                item = listCtrl.ItemsSource.Items[index];
                if (selectedItems.Selected(item) == false)
                {
                    return item;
                }
                index--;
            }

            return null;
        }
    }
}
