﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Framework.Windows.Forms.CommandHandlers
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using NintendoWare.SoundFoundation.CommandHandlers;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Framework.CommandHandlers;
    using NintendoWare.SoundMaker.Framework.Commands;

    ///--------------------------------------------------------------------------
    /// <summary>
    ///
    /// </summary>
    public class RedoHandler : CommandHandler
    {
        ///--------------------------------
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public RedoHandler(IQueryCommandParameter queryParameter) :
            base(queryParameter)
        {
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public override string TargetCommandID
        {
            get { return EditCommands.Redo.ID; }
        }

        ///--------------------------------
        /// <summary>
        /// コマンドを実行できるかどうか調べる
        /// </summary>
        protected override CommandStatus QueryStatusInternal(Command command, IQueryCommandParameter parameters)
        {
            SoundDocument document = GetTargetDocument(parameters);

            if (null == document) { return CommandStatus.SupportedAndVisible; }
            return document.OperationHistory.CanRedo() ?
                CommandStatus.SupportedAndEnabledAndVisible : CommandStatus.SupportedAndVisible;
        }

        ///--------------------------------
        /// <summary>
        /// コマンドの実行
        /// </summary>
        protected override bool ExecuteInternal(Command command, IQueryCommandParameter parameters)
        {
            return GetTargetDocument(parameters).OperationHistory.Redo();
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private SoundDocument GetTargetDocument(IQueryCommandParameter parameters)
        {
            if (null == parameters) { throw new ArgumentNullException("parameters"); }

            if (!parameters.ContainsParameter(CommandParameterNames.TargetDocuments))
            {
                return null;
            }

            return (parameters.GetParameter(CommandParameterNames.TargetDocuments)
                     as IEnumerable<SoundDocument>).FirstOrDefault();
        }
    }
}
