﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms.CommandHandlers
{
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Framework.CommandHandlers;
    using NintendoWare.SoundMaker.Framework.Commands;
    using NintendoWare.SoundMaker.Framework.Preset;

    ///--------------------------------------------------------------------------
    /// <summary>
    /// "ブックマークフォルダの作成"ハンドラ
    /// </summary>

    public class CreateBookmarkFolderHandler : EditCommandHandler
    {
        public CreateBookmarkFolderHandler(IQueryCommandParameter queryParameter)
            : base(EditCommands.CreateBookmarkFolder.ID, queryParameter)
        {
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override bool ExecuteInternal(Command command, IQueryCommandParameter parameters)
        {
            Component[] components = GetTargetComponents(parameters);

            if (components.Length == 0)
            {
                ApplicationBase.Instance.BookmarkService.CreateBookmarkFolder(null);
            }
            else
            {
                ApplicationBase.Instance.BookmarkService.CreateBookmarkFolder(components[0] as BookmarkComponent);
            }

            return true;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override CommandStatus QueryStatusInternal(Command command, IQueryCommandParameter parameters)
        {
            CommandStatus result = CommandStatus.SupportedAndVisible;
            Component[] components = GetTargetComponents(parameters);

            if (1 < components.Length)
            {
                result = CommandStatus.SupportedAndVisible;
            }
            else
            {
                result = CommandStatus.SupportedAndEnabledAndVisible;
            }

            return result;
        }
    }
}
