﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using NintendoWare.SoundFoundation.Commands;
using NintendoWare.SoundFoundation.Projects;
using NintendoWare.SoundMaker.Framework.CommandHandlers;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms.CommandHandlers
{
    ///--------------------------------------------------------------------------
    /// <summary>
    /// Bank関連"切り取り"ハンドラ
    /// </summary>
    public class CutBankPanelHandler : CutHandler
    {
        private CaretItemSetter _CaretItemSetter = new CaretItemSetter();

        ///--------------------------------
        /// <summary>
        /// </summary>
        public CutBankPanelHandler(IQueryCommandParameter queryParameter)
            : base(queryParameter)
        {
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override CommandStatus QueryStatusInternal(Command command, IQueryCommandParameter parameters)
        {
            SoundDocument document = GetTargetDocument(parameters);
            Component[] components = GetTargetComponents(parameters);

            if (null == document) { return CommandStatus.SupportedAndVisible; }
            if (null == components) { return CommandStatus.SupportedAndVisible; }

            if (document.IsReadOnly == true)
            {
                return CommandStatus.SupportedAndVisible;
            }

            if (components.Length == 1)
            {
                if (components[0] is KeyRegion ||
                     components[0] is VelocityRegion)
                {
                    return CommandStatus.SupportedAndEnabledAndVisible;
                }
            }
            else
            {
                foreach (Component component in components)
                {
                    if (component is KeyRegion == true ||
                         component is VelocityRegion == true)
                    {
                        return CommandStatus.SupportedAndVisible;
                    }
                }
            }

            return components.Length > 0 ?
                CommandStatus.SupportedAndEnabledAndVisible : CommandStatus.SupportedAndVisible;
        }

        ///--------------------------------
        /// <summary>
        /// </summary>
        protected override bool ExecuteInternal(Command command, IQueryCommandParameter parameters)
        {
            SoundDocument document = GetTargetDocument(parameters);
            Component[] components = GetTargetComponents(parameters);

            if (components == null)
            {
                return false;
            }

            _CaretItemSetter.PreserveNextItem(parameters);

            if (components[0] is KeyRegion || components[0] is VelocityRegion)
            {
                if (!OnDeleting(parameters, components)) { return false; }
                //components = SelectedRemoveComponents( components );
                {
                    try
                    {
                        document.OperationHistory.BeginTransaction();
                        DeleteBankPanelHandler.RemoveRegionComponents(document, components);
                        document.OperationHistory.EndTransaction();
                    }
                    catch
                    {
                        document.OperationHistory.CancelTransaction();
                    }
                }
            }
            else
            {
                base.ExecuteInternal(command, parameters);
            }

            _CaretItemSetter.SetCaretByPreservedItem(parameters);
            return true;
        }
    }
}
