﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;

namespace NintendoWare.SoundMaker.Framework.Preview.Communications.Utility
{
    /// <summary>
    ///
    /// </summary>
    public class CommunicationsMessageService
    {
        public CommunicationsMessageService()
        {
            ReadingSoundArchive = "ReadingSoundArchive";
            ReadingModel = "ReadingModel";
            ReadingAnimation = "ReadingAnimation";
            ReadingAnimSound = "ReadingAnimSound";
            SoundNameTooLong = "SoundNameTooLong";
            ConvertingModel = "ConvertingModel";
            ConvertingAnimation = "ConvertingAnimation";
            ConvertingAnimSound = "ConvertingAnimSound";
            DisposingCache = "DisposingCache";
        }

        public static string ReadingSoundArchive { get; set; }
        public static string ReadingModel { get; set; }
        public static string ReadingAnimation { get; set; }
        public static string ReadingAnimSound { get; set; }
        public static string SoundNameTooLong { get; set; }
        public static string ConvertingModel { get; set; }
        public static string ConvertingAnimation { get; set; }
        public static string ConvertingAnimSound { get; set; }
        public static string DisposingCache { get; set; }
    }

    /// <summary>
    ///
    /// </summary>
    public class Validator
    {
        public static void Assert(bool value)
        {
            Assert(value, new Exception());
        }

        public static void Assert(bool value, Exception e)
        {
            if (!value)
            {
                Debug.Assert(false, "Value is true");
                throw e;
            }
        }

        public static void NullAssert(object obj)
        {
            NullAssert(obj, new Exception());
        }

        public static void NullAssert(object obj, Exception e)
        {
            Debug.Assert(null != obj, "Obj is null");
            CheckVariable(obj, e);
        }

        public static void CheckArgument(object obj)
        {
            CheckVariable(obj, new ArgumentNullException());
        }

        public static void CheckArgument(object obj, string message)
        {
            CheckVariable(obj, new ArgumentNullException(message));
        }

        public static void CheckVariable(object obj)
        {
            CheckVariable(obj, new Exception());
        }

        public static void CheckVariable(object obj, string message)
        {
            CheckVariable(obj, new Exception(message));
        }

        public static void CheckVariable(object obj, Exception e)
        {
            if (obj != null) { return; }

            if (null == e)
            {
                throw new Exception();
            }
            else
            {
                throw e;
            }
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class LocableMethodInvoker
    {
        // 状態
        private bool _locked = false;
        private bool _dirty = false;

        #region ** プロパティ

        public bool Locked
        {
            get { return _locked; }
        }
        public bool Dirty
        {
            get { return _dirty; }
        }

        #endregion

        #region ** メソッド

        public bool Invoke(Delegate e)
        {
            return Invoke(e, null);
        }

        public bool Invoke(Delegate method, params object[] args)
        {
            _dirty = true;
            if (_locked) { return false; }

            if (null != method)
            {
                method.DynamicInvoke(args);
            }

            _dirty = false;
            return true;
        }

        public void Lock()
        {
            if (_locked) { return; }
            _locked = true;
        }

        public void Unlock(Delegate method)
        {
            Unlock(method, null);
        }

        public void Unlock(Delegate method, params object[] args)
        {
            _locked = false;

            if (!_dirty) { return; }

            Invoke(method, args);
        }

        public void Reset()
        {
            _dirty = false;
        }

        #endregion
    }

    /// <summary>
    ///
    /// </summary>
    public class NSingletonHolder<_Type> where _Type : class, new()
    {
        private static volatile _Type _instance = null;
        private static object _lock = new object();

        #region ** プロパティ

        public static _Type Instance
        {
            get
            {
                if (null != _instance) { return _instance; }

                lock (_lock)
                {

                    if (null != _instance) { return _instance; }
                    _instance = new _Type();

                }

                return _instance;
            }
        }

        #endregion
    }
}
