﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;

namespace NintendoWare.SoundMaker.Framework.Preview.Communications.Tool
{
    using NintendoWare.SoundMaker.Framework.Preview.Communications;

    /// <summary>
    /// ツールパケット
    /// <para>
    /// ツールからビューアに送るパケットのベースクラスです。
    /// </para>
    /// </summary>
    public abstract class ToolPacket : CommPacket
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ToolPacket()
        {
            Debug.Assert(!Error, "Error is false");
        }

        /// <summary>
        /// 送信パケットの圧縮
        /// </summary>
        public virtual bool Compress(ToolPacket nextPacket)
        {
            // 圧縮できるパケットは次のパケットを混ぜ込んでtrueを返す
            return false;
        }

        /// <summary>
        /// パケット送信
        /// </summary>
        protected static void SendPacket(ToolPacket packet)
        {
            if (CommManager.Instance != null)
            {
                CommManager.Instance.SendPacket(packet);
            }
        }
    }
}
