﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Xml.Serialization;

namespace NintendoWare.SoundMaker.Framework.Configurations.Schemas
{
    /// <summary>
    /// ウィンドウ設定を格納します。
    /// </summary>
    public partial class XmlWindow
    {
        /// <summary>
        /// ウィンドウ位置を取得または設定します。
        /// </summary>
        [XmlIgnore]
        public Rectangle Bounds
        {
            get { return new Rectangle(X, Y, Width, Height); }
            set
            {
                if (null == value) { throw new ArgumentNullException("value"); }

                X = value.X;
                Y = value.Y;
                Width = value.Width;
                Height = value.Height;

                XSpecified = true;
                YSpecified = true;
                WidthSpecified = true;
                HeightSpecified = true;
            }
        }

    }
}
