﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker.Framework.Configurations.Schemas
{
    using NintendoWare.SoundFoundation.Projects;

    public partial class XmlSndEdit
    {
        public XmlSndEdit() { }

        public XmlSndEdit(Component component)
        {
            SoundSet soundSet = component.GetSoundSet();
            SoundSetName = soundSet == null ? string.Empty : soundSet.Name;
            Type = component.GetComponentTypeName();
            Name = component.Name;
            Enabled = (bool)component.Parameters[ProjectParameterNames.SndEditEnabled].Value;
        }
    }

    public static class ComponentEx
    {
        public static SoundSet GetSoundSet(this Component component)
        {
            if (component == null) { return null; }
            else if (component is SoundSet) { return component as SoundSet; }
            else if (component.Parent != null) { return component.Parent.GetSoundSet(); }
            else { return null; }
        }

        public static string GetComponentTypeName(this Component component)
        {
            if (component is StreamSoundBase) { return "StreamSound"; }
            else if (component is WaveSoundBase) { return "WaveSound"; }
            else if (component is SequenceSoundBase) { return "SequenceSound"; }
            else if (component is Bank) { return "Bank"; }
            else { return string.Empty; }
        }
    }
}
