﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace NintendoWare.SoundMaker.Framework.Configurations.Schemas
{
    /// <summary>
    /// メインウィンドウ設定を格納します。
    /// </summary>
    public partial class XmlMainWindow
    {
        /// <summary>
        /// メインウィンドウに含まれる全タブコントロールの一覧を取得します。
        /// </summary>
        /// <returns>全タブコントロールが含まれたディクショナリ。</returns>
        public IDictionary<string, XmlTab> CreateTabDictionary()
        {
            Dictionary<string, XmlTab> result = new Dictionary<string, XmlTab>();
            if (null == Editor) { return result; }
            if (null == Editor.Tabs) { return result; }

            foreach (XmlTab xmlTab in Editor.Tabs.Tab)
            {
                result.Add(xmlTab.Name, xmlTab);
            }

            return result;
        }
    }
}
