﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using System.Linq;

namespace NintendoWare.SoundMaker.Framework.Configurations.Schemas
{
    /// <summary>
    /// 全てのリストカラム設定を格納します。
    /// </summary>
    public partial class XmlListColumns
    {
        /// <summary>
        /// XmlListColumns の内容をディクショナリにエクスポートします。
        /// </summary>
        /// <returns>全 XmlListColumn が含まれたディクショナリ。</returns>
        public IDictionary<string, XmlListColumn> ExportDictionary()
        {
            Dictionary<string, XmlListColumn> result = new Dictionary<string, XmlListColumn>();

            foreach (XmlListColumn xmlColumn in ListColumn)
            {
                result.Add(xmlColumn.Name, xmlColumn);
            }

            return result;
        }

        /// <summary>
        /// リストカラム設定をインポートします。
        /// </summary>
        /// <param name="xmlColumns">リストカラム設定。</param>
        public void Import(IEnumerable<XmlListColumn> xmlColumns)
        {
            ListColumn = xmlColumns.ToArray();
        }
    }
}
