﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Configurations
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.Diagnostics;
    using System.Linq;
    using Framework.Resources;
    using SoundFoundation.Core.Collections;
    using SoundFoundation.Projects;

    /// <summary>
    /// 全てのリストの特性を管理します。
    /// </summary>
    public class ListTraits
    {
        #region ** 固定値

        public const string ListName_StreamSound = "StreamSoundList";
        public const string ListName_StreamSoundTrack = "StreamSoundTrackList";
        public const string ListName_WaveSoundSet = "WaveSoundSetList";
        public const string ListName_WaveSoundSetItem = "WaveSoundSetItemList";
        public const string ListName_SequenceSoundSet = "SequenceSoundSetList";
        public const string ListName_SequenceSoundSetItem = "SequenceSoundSetItemList";
        public const string ListName_SequenceSound = "SequenceSoundList";
        public const string ListName_Bank = "BankList";
        public const string ListName_WaveArchive = "WaveArchiveList";
        public const string ListName_Player = "PlayerList";
        public const string ListName_Group = "GroupList";
        public const string ListName_GroupItem = "GroupItemList";
        public const string ListName_Instrument = "InstrumentList";
        public const string ListName_Percussion = "PercussionList";
        public const string ListName_FindResult = "FindResultList";
        public const string ListName_FindResult2 = "FindResult2List";
        public const string ListName_MultipleBank = "MultipleBankList";

        public const string ListName_History = "HistoryList";
        public const string ListName_MeasureReferenceCountFilePath = "MeasureReferenceCountFilePath";
        public const string ListName_MeasureReferenceCountInstrument = "MeasureReferenceCountInstrument";

        public const string ListName_SndEdit = "SndEditList";

        public const string ColumnName_ActorPlayer = ProjectParameterNames.Sound.ActorPlayer;
        public const string ColumnName_AuxASend = ProjectParameterNames.Sends.AuxASend;
        public const string ColumnName_AuxBSend = ProjectParameterNames.Sends.AuxBSend;
        public const string ColumnName_SoundSetBankReferences = ProjectParameterNames.SequenceSound.SoundSetBankReferences;

        public const string ColumnName_SoundSetBankReference0 = ProjectParameterNames.SequenceSound.SoundSetBankReference0;
        public const string ColumnName_SoundSetBankReference1 = ProjectParameterNames.SequenceSound.SoundSetBankReference1;
        public const string ColumnName_SoundSetBankReference2 = ProjectParameterNames.SequenceSound.SoundSetBankReference2;
        public const string ColumnName_SoundSetBankReference3 = ProjectParameterNames.SequenceSound.SoundSetBankReference3;

        public const string ColumnName_ChannelPriority = ProjectParameterNames.Sound.ChannelPriority;
        public const string ColumnName_Comment = ProjectParameterNames.Comment;
        public const string ColumnName_Comment1 = ProjectParameterNames.Comment1;
        public const string ColumnName_Comment2 = ProjectParameterNames.Comment2;
        public const string ColumnName_Comment3 = ProjectParameterNames.Comment3;
        public const string ColumnName_Comment4 = ProjectParameterNames.Comment4;
        public const string ColumnName_Comment5 = ProjectParameterNames.Comment5;
        public const string ColumnName_Comment6 = ProjectParameterNames.Comment6;
        public const string ColumnName_Comment7 = ProjectParameterNames.Comment7;
        public const string ColumnName_Comment8 = ProjectParameterNames.Comment8;
        public const string ColumnName_Comment9 = ProjectParameterNames.Comment9;
        public const string ColumnName_DataSize = "DataSize";
        public const string ColumnName_DecayCurve3D = ProjectParameterNames.Sound3D.DecayCurve3D;
        public const string ColumnName_DecayRatio3D = ProjectParameterNames.Sound3D.DecayRatio3D;
        public const string ColumnName_DopplerFactor3D = ProjectParameterNames.Sound3D.DopplerFactor3D;
        public const string ColumnName_Enable3DFilter = ProjectParameterNames.Sound3D.Enable3DFilter;
        public const string ColumnName_Enable3DPan = ProjectParameterNames.Sound3D.Enable3DPan;
        public const string ColumnName_Enable3DPriority = ProjectParameterNames.Sound3D.Enable3DPriority;
        public const string ColumnName_Enable3DSurroundPan = ProjectParameterNames.Sound3D.Enable3DSurroundPan;
        public const string ColumnName_Enable3DVolume = ProjectParameterNames.Sound3D.Enable3DVolume;
        public const string ColumnName_EnvelopeAttack = ProjectParameterNames.Envelope.Attack;
        public const string ColumnName_EnvelopeDecay = ProjectParameterNames.Envelope.Decay;
        public const string ColumnName_EnvelopeHold = ProjectParameterNames.Envelope.Hold;
        public const string ColumnName_EnvelopeRelease = ProjectParameterNames.Envelope.Release;
        public const string ColumnName_EnvelopeSustain = ProjectParameterNames.Envelope.Sustain;
        public const string ColumnName_FilePath = ProjectParameterNames.FilePath;
        public const string ColumnName_FileType = ProjectParameterNames.SequenceSound.FileType;
        public const string ColumnName_GroupItemTargetName = ProjectParameterNames.TargetItemReference;
        public const string ColumnName_GroupItemTargetSoundSet = "GroupItemTargetSoundSet";
        public const string ColumnName_GroupOutputType = ProjectParameterNames.Group.OutputType;
        public const string ColumnName_ItemIndex = "ItemIndex";
        public const string ColumnName_ItemLocation = "ItemLocation";
        public const string ColumnName_ItemType = "ItemType";
        public const string ColumnName_KeyGroup = ProjectParameterNames.VelocityRegion.KeyGroup;
        public const string ColumnName_MainSend = ProjectParameterNames.Sends.MainSend;
        public const string ColumnName_Name = ProjectParameterNames.Name;
        public const string ColumnName_OriginalKey = ProjectParameterNames.VelocityRegion.OriginalKey;
        public const string ColumnName_Pan = ProjectParameterNames.Pan;
        public const string ColumnName_PanCurve = ProjectParameterNames.PanCurve;
        public const string ColumnName_PanMode = ProjectParameterNames.PanMode;
        public const string ColumnName_PercussionMode = "PercussionMode";
        public const string ColumnName_Pitch = ProjectParameterNames.Pitch;
        public const string ColumnName_PitchCents = ProjectParameterNames.VelocityRegion.PitchCents;
        public const string ColumnName_PitchSemitones = ProjectParameterNames.VelocityRegion.PitchSemitones;
        public const string ColumnName_PlayerHeapSize = ProjectParameterNames.Player.HeapSize;
        public const string ColumnName_PlayerPriority = ProjectParameterNames.Sound.PlayerPriority;
        public const string ColumnName_PlayerReference = ProjectParameterNames.Sound.PlayerReference;
        public const string ColumnName_PlayerSoundLimit = ProjectParameterNames.Player.SoundLimit;
        public const string ColumnName_ProgramNo = ProjectParameterNames.Instrument.ProgramNo;
        public const string ColumnName_ReleasePriorityFixed = ProjectParameterNames.Sound.ReleasePriorityFixed;
        public const string ColumnName_StartPosition = ProjectParameterNames.SequenceSound.StartPosition;
        public const string ColumnName_SurroundPan = ProjectParameterNames.SurroundPan;
        public const string ColumnName_UserParameter0 = ProjectParameterNames.Sound.UserParameter;
        public const string ColumnName_UserParameter1 = ProjectParameterNames.Sound.UserParameter1;
        public const string ColumnName_UserParameter2 = ProjectParameterNames.Sound.UserParameter2;
        public const string ColumnName_UserParameter3 = ProjectParameterNames.Sound.UserParameter3;

        public const string ColumnName_SinglePlayType = ProjectParameterNames.Sound.SinglePlayType;
        public const string ColumnName_SinglePlayEffectiveDuration = ProjectParameterNames.Sound.SinglePlayEffectiveDuration;

        public const string ColumnName_Volume = ProjectParameterNames.Volume;
        public const string ColumnName_TrackVolume = ProjectParameterNames.StreamSoundTrack.TrackVolume;

        public const string ColumnName_TrackMainSend = ProjectParameterNames.StreamSoundTrack.Sends.MainSend;
        public const string ColumnName_TrackAuxASend = ProjectParameterNames.StreamSoundTrack.Sends.AuxASend;
        public const string ColumnName_TrackAuxBSend = ProjectParameterNames.StreamSoundTrack.Sends.AuxBSend;

        public const string ColumnName_WaveArchiveLoadType = ProjectParameterNames.WaveArchive.LoadType;
        public const string ColumnName_WaveTime = ProjectParameterNames.WaveTime;
        public const string ColumnName_WaveTick = ProjectParameterNames.WaveTick;
        public const string ColumnName_SampleRate = ProjectParameterNames.SampleRate;
        public const string ColumnName_WaveBitRate = ProjectParameterNames.WaveBitRate;
        public const string ColumnName_WaveSampleBit = ProjectParameterNames.WaveSampleBit;
        public const string ColumnName_WaveChannel = ProjectParameterNames.WaveChannel;
        public const string ColumnName_WaveArchiveReference = ProjectParameterNames.SoundSetItem.WaveArchiveReference;
        public const string ColumnName_WaveEncoding = ProjectParameterNames.WaveEncoding;
        public const string ColumnName_WaveSoundEnvelopeRelease = ProjectParameterNames.WaveSound.EnvelopeRelease;
        public const string ColumnName_IsPrefetchEnabled = ProjectParameterNames.StreamSound.IsPrefetchEnabled;
        public const string ColumnName_IsResampleEnabled = ProjectParameterNames.IsResampleEnabled;
        public const string ColumnName_IsDownMixEnabled = ProjectParameterNames.IsDownMixEnabled;

        public const string ColumnName_PreviewPlay = ProjectParameterNames.SoundSetItem.PreviewPlay;
        public const string ColumnName_PreviewMute = ProjectParameterNames.StreamSoundTrack.PreviewMute;
        public const string ColumnName_PreviewSoloPlay = ProjectParameterNames.StreamSoundTrack.PreviewSoloPlay;


        public const string ColumnName_GroupItemRegisterType = ProjectParameterNames.GroupItem.RegisterType;
        public const string ColumnName_InterpolationType = "InterpolationType";

        public const string ColumnName_FrontBypass = ProjectParameterNames.FrontBypass;
        public const string ColumnName_LPF = ProjectParameterNames.LPF;
        public const string ColumnName_BiquadType = ProjectParameterNames.BiquadType;
        public const string ColumnName_Biquad = ProjectParameterNames.Biquad;
        public const string ColumnName_TrackNo = ProjectParameterNames.StreamSoundTrack.TrackNo;
        public const string ColumnName_ChannelNo = "ChannelNo";

        public const string ColumnName_DateTime = "DateTime";
        public const string ColumnName_ReferenceCount = "ReferenceCount";
        public const string ColumnName_MaximumVoiceCount = "MaximumVoiceCount";

        public const string ColumnName_IntegratedLoudness = "IntegratedLoudness";

        public const string ColumnName_SndEdit = ProjectParameterNames.SndEdit;
        public const string ColumnName_SndEditEnabled = ProjectParameterNames.SndEditEnabled;

        public static string[,] ColumnName_UserParameters { get; set; }

        #endregion

        private readonly ListTraitDictionary _listTraits = new ListTraitDictionary();
        private readonly ListColumnDictionary _columns = new ListColumnDictionary();
        private readonly ListType2NameDictionary _listNames = new ListType2NameDictionary();

        /// <summary>
        ///
        /// </summary>
        static ListTraits()
        {
            ColumnName_UserParameters = new string[4, 32];

            for (int i = 0; i < 4; i++)
            {
                for (int j = 0; j < 32; j++)
                {
                    ColumnName_UserParameters[i, j] = "UserParameter_" + i + "_" + j;
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        public ListTraits()
        {
            InitializeTypes();
            InitializeColumns();
            InitializeLists();
        }

        /// <summary>
        ///
        /// </summary>
        public IReadOnlyDictionary<string, ListColumnTrait> Columns
        {
            get { return _columns; }
        }

        /// <summary>
        ///
        /// </summary>
        public IReadOnlyDictionary<Type, string> ListNames
        {
            get { return _listNames; }
        }

        /// <summary>
        ///
        /// </summary>
        public IReadOnlyDictionary<string, ListTrait> Lists
        {
            get { return _listTraits; }
        }

        /// <summary>
        ///
        /// </summary>
        public static string[] GetAllCommentColumnNames()
        {
            return new string[] {
                ProjectParameterNames.Comment,
                ProjectParameterNames.Comment1,
                ProjectParameterNames.Comment2,
                ProjectParameterNames.Comment3,
                ProjectParameterNames.Comment4,
                ProjectParameterNames.Comment5,
                ProjectParameterNames.Comment6,
                ProjectParameterNames.Comment7,
                ProjectParameterNames.Comment8,
                ProjectParameterNames.Comment9,
            };
        }

        /// <summary>
        ///
        /// </summary>
        public static string[] GetAllUserParametersColumnNames()
        {
            List<string> names = new List<string>();

            for (int i = 0; i <= 3; i++)
            {
                for (int j = 0; j < 32; j++)
                {
                    names.Add(ColumnName_UserParameters[i, j]);
                }
            }

            return names.ToArray();
        }

        /// <summary>
        ///
        /// </summary>
        public static bool IsUserParameters(string name)
        {
            return System.Text.RegularExpressions.Regex.IsMatch(name, "UserParameter_[0-3]+_[0-9]+");
        }

        /// <summary>
        ///
        /// </summary>
        public static bool IsSoundSetBankReference(string name)
        {
            switch (name)
            {
                case ProjectParameterNames.SequenceSound.SoundSetBankReference0:
                case ProjectParameterNames.SequenceSound.SoundSetBankReference1:
                case ProjectParameterNames.SequenceSound.SoundSetBankReference2:
                case ProjectParameterNames.SequenceSound.SoundSetBankReference3:
                    return true;
                default:
                    return false;
            }
        }

        /// <summary>
        ///
        /// </summary>
        protected virtual void InitializeTypes()
        {
            _listNames.Add(typeof(StreamSoundPack), ListName_StreamSound);
            _listNames.Add(typeof(StreamSoundBase), ListName_StreamSoundTrack);
            _listNames.Add(typeof(WaveSoundSetPack), ListName_WaveSoundSet);
            _listNames.Add(typeof(WaveSoundSetBase), ListName_WaveSoundSetItem);
            _listNames.Add(typeof(SequenceSoundSetPack), ListName_SequenceSoundSet);
            _listNames.Add(typeof(SequenceSoundSetBase), ListName_SequenceSoundSetItem);
            _listNames.Add(typeof(SequenceSoundPack), ListName_SequenceSound);
            _listNames.Add(typeof(SoundSetBankPack), ListName_Bank);
            _listNames.Add(typeof(WaveArchivePack), ListName_WaveArchive);
            _listNames.Add(typeof(PlayerPack), ListName_Player);
            _listNames.Add(typeof(GroupPack), ListName_Group);
            _listNames.Add(typeof(GroupBase), ListName_GroupItem);
            _listNames.Add(typeof(Bank), ListName_Instrument);
        }

        protected virtual void InitializeLists()
        {
            AddList(ListName_StreamSound,
                     new string[] {
                         ColumnName_SndEdit,
                         ColumnName_PreviewPlay,
                         ColumnName_Name,
                         ColumnName_SinglePlayType,
                         ColumnName_SinglePlayEffectiveDuration,
                         ColumnName_WaveEncoding,
                         ColumnName_FilePath,
                         ColumnName_WaveTime,
                         ColumnName_IsResampleEnabled,
                         ColumnName_SampleRate,
                         ColumnName_WaveBitRate,
                         ColumnName_WaveSampleBit,
                         ColumnName_IsDownMixEnabled,
                         ColumnName_WaveChannel,
                         ColumnName_Volume,
                         ColumnName_IntegratedLoudness,
                         ColumnName_PlayerPriority,
                         ColumnName_PlayerReference,
                         ColumnName_ActorPlayer,
                         ColumnName_Enable3DVolume,
                         ColumnName_Enable3DPan,
                         ColumnName_Enable3DSurroundPan,
                         ColumnName_Enable3DPriority,
                         ColumnName_Enable3DFilter,
                         ColumnName_DecayCurve3D,
                         ColumnName_DecayRatio3D,
                         ColumnName_DopplerFactor3D,
                         ColumnName_PanMode,
                         ColumnName_PanCurve,
                         ColumnName_FrontBypass,
                         ColumnName_Pitch,

                         ColumnName_AuxASend,
                         ColumnName_AuxBSend,
                         ColumnName_MainSend,

                         ColumnName_UserParameter0,
                         ColumnName_UserParameter1,
                         ColumnName_UserParameter2,
                         ColumnName_UserParameter3,

                         ColumnName_UserParameters[0,0],
                         ColumnName_UserParameters[0,1],
                         ColumnName_UserParameters[0,2],
                         ColumnName_UserParameters[0,3],
                         ColumnName_UserParameters[0,4],
                         ColumnName_UserParameters[0,5],
                         ColumnName_UserParameters[0,6],
                         ColumnName_UserParameters[0,7],
                         ColumnName_UserParameters[0,8],
                         ColumnName_UserParameters[0,9],
                         ColumnName_UserParameters[0,10],
                         ColumnName_UserParameters[0,11],
                         ColumnName_UserParameters[0,12],
                         ColumnName_UserParameters[0,13],
                         ColumnName_UserParameters[0,14],
                         ColumnName_UserParameters[0,15],
                         ColumnName_UserParameters[0,16],
                         ColumnName_UserParameters[0,17],
                         ColumnName_UserParameters[0,18],
                         ColumnName_UserParameters[0,19],
                         ColumnName_UserParameters[0,20],
                         ColumnName_UserParameters[0,21],
                         ColumnName_UserParameters[0,22],
                         ColumnName_UserParameters[0,23],
                         ColumnName_UserParameters[0,24],
                         ColumnName_UserParameters[0,25],
                         ColumnName_UserParameters[0,26],
                         ColumnName_UserParameters[0,27],
                         ColumnName_UserParameters[0,28],
                         ColumnName_UserParameters[0,29],
                         ColumnName_UserParameters[0,30],
                         ColumnName_UserParameters[0,31],
                         ColumnName_UserParameters[1,0],
                         ColumnName_UserParameters[1,1],
                         ColumnName_UserParameters[1,2],
                         ColumnName_UserParameters[1,3],
                         ColumnName_UserParameters[1,4],
                         ColumnName_UserParameters[1,5],
                         ColumnName_UserParameters[1,6],
                         ColumnName_UserParameters[1,7],
                         ColumnName_UserParameters[1,8],
                         ColumnName_UserParameters[1,9],
                         ColumnName_UserParameters[1,10],
                         ColumnName_UserParameters[1,11],
                         ColumnName_UserParameters[1,12],
                         ColumnName_UserParameters[1,13],
                         ColumnName_UserParameters[1,14],
                         ColumnName_UserParameters[1,15],
                         ColumnName_UserParameters[1,16],
                         ColumnName_UserParameters[1,17],
                         ColumnName_UserParameters[1,18],
                         ColumnName_UserParameters[1,19],
                         ColumnName_UserParameters[1,20],
                         ColumnName_UserParameters[1,21],
                         ColumnName_UserParameters[1,22],
                         ColumnName_UserParameters[1,23],
                         ColumnName_UserParameters[1,24],
                         ColumnName_UserParameters[1,25],
                         ColumnName_UserParameters[1,26],
                         ColumnName_UserParameters[1,27],
                         ColumnName_UserParameters[1,28],
                         ColumnName_UserParameters[1,29],
                         ColumnName_UserParameters[1,30],
                         ColumnName_UserParameters[1,31],
                         ColumnName_UserParameters[2,0],
                         ColumnName_UserParameters[2,1],
                         ColumnName_UserParameters[2,2],
                         ColumnName_UserParameters[2,3],
                         ColumnName_UserParameters[2,4],
                         ColumnName_UserParameters[2,5],
                         ColumnName_UserParameters[2,6],
                         ColumnName_UserParameters[2,7],
                         ColumnName_UserParameters[2,8],
                         ColumnName_UserParameters[2,9],
                         ColumnName_UserParameters[2,10],
                         ColumnName_UserParameters[2,11],
                         ColumnName_UserParameters[2,12],
                         ColumnName_UserParameters[2,13],
                         ColumnName_UserParameters[2,14],
                         ColumnName_UserParameters[2,15],
                         ColumnName_UserParameters[2,16],
                         ColumnName_UserParameters[2,17],
                         ColumnName_UserParameters[2,18],
                         ColumnName_UserParameters[2,19],
                         ColumnName_UserParameters[2,20],
                         ColumnName_UserParameters[2,21],
                         ColumnName_UserParameters[2,22],
                         ColumnName_UserParameters[2,23],
                         ColumnName_UserParameters[2,24],
                         ColumnName_UserParameters[2,25],
                         ColumnName_UserParameters[2,26],
                         ColumnName_UserParameters[2,27],
                         ColumnName_UserParameters[2,28],
                         ColumnName_UserParameters[2,29],
                         ColumnName_UserParameters[2,30],
                         ColumnName_UserParameters[2,31],
                         ColumnName_UserParameters[3,0],
                         ColumnName_UserParameters[3,1],
                         ColumnName_UserParameters[3,2],
                         ColumnName_UserParameters[3,3],
                         ColumnName_UserParameters[3,4],
                         ColumnName_UserParameters[3,5],
                         ColumnName_UserParameters[3,6],
                         ColumnName_UserParameters[3,7],
                         ColumnName_UserParameters[3,8],
                         ColumnName_UserParameters[3,9],
                         ColumnName_UserParameters[3,10],
                         ColumnName_UserParameters[3,11],
                         ColumnName_UserParameters[3,12],
                         ColumnName_UserParameters[3,13],
                         ColumnName_UserParameters[3,14],
                         ColumnName_UserParameters[3,15],
                         ColumnName_UserParameters[3,16],
                         ColumnName_UserParameters[3,17],
                         ColumnName_UserParameters[3,18],
                         ColumnName_UserParameters[3,19],
                         ColumnName_UserParameters[3,20],
                         ColumnName_UserParameters[3,21],
                         ColumnName_UserParameters[3,22],
                         ColumnName_UserParameters[3,23],
                         ColumnName_UserParameters[3,24],
                         ColumnName_UserParameters[3,25],
                         ColumnName_UserParameters[3,26],
                         ColumnName_UserParameters[3,27],
                         ColumnName_UserParameters[3,28],
                         ColumnName_UserParameters[3,29],
                         ColumnName_UserParameters[3,30],
                         ColumnName_UserParameters[3,31],

                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                     });

            AddList(ListName_StreamSoundTrack,
                     new string[] {
                         ColumnName_TrackNo,
                         ColumnName_ChannelNo,
                         ColumnName_PreviewMute,
                         ColumnName_PreviewSoloPlay,
                         ColumnName_FilePath,
                         ColumnName_WaveTime,
                         ColumnName_SampleRate,
                         ColumnName_WaveBitRate,
                         ColumnName_WaveSampleBit,
                         ColumnName_WaveChannel,
                         ColumnName_Volume,
                         ColumnName_Pan,
                         ColumnName_SurroundPan,
                         ColumnName_FrontBypass,
                         ColumnName_LPF,
                         ColumnName_BiquadType,
                         ColumnName_Biquad,

                         ColumnName_AuxASend,
                         ColumnName_AuxBSend,
                         ColumnName_MainSend,

                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                     });

            AddList(ListName_WaveSoundSet,
                    new string[] {
                         ColumnName_Name,
                         ColumnName_WaveArchiveReference,
                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_WaveSoundSetItem,
                    new string[] {
                         ColumnName_SndEdit,
                         ColumnName_PreviewPlay,
                         ColumnName_Name,
                         ColumnName_SinglePlayType,
                         ColumnName_SinglePlayEffectiveDuration,
                         ColumnName_WaveEncoding,
                         ColumnName_FilePath,
                         ColumnName_WaveTime,
                         ColumnName_IsResampleEnabled,
                         ColumnName_SampleRate,
                         ColumnName_WaveBitRate,
                         ColumnName_WaveSampleBit,
                         ColumnName_IsDownMixEnabled,
                         ColumnName_WaveChannel,
                         ColumnName_DataSize,
                         ColumnName_Volume,
                         ColumnName_IntegratedLoudness,
                         ColumnName_ChannelPriority,
                         ColumnName_PlayerPriority,
                         ColumnName_PlayerReference,
                         ColumnName_ActorPlayer,
                         ColumnName_Pan,
                         ColumnName_SurroundPan,
                         ColumnName_Pitch,
                         ColumnName_LPF,
                         ColumnName_BiquadType,
                         ColumnName_Biquad,
                         ColumnName_WaveSoundEnvelopeRelease,

                         ColumnName_AuxASend,
                         ColumnName_AuxBSend,
                         ColumnName_MainSend,

                         ColumnName_ReleasePriorityFixed,
                         ColumnName_Enable3DVolume,
                         ColumnName_Enable3DPan,
                         ColumnName_Enable3DSurroundPan,
                         ColumnName_Enable3DPriority,
                         ColumnName_Enable3DFilter,
                         ColumnName_DecayCurve3D,
                         ColumnName_DecayRatio3D,
                         ColumnName_DopplerFactor3D,
                         ColumnName_PanMode,
                         ColumnName_PanCurve,
                         ColumnName_FrontBypass,

                         ColumnName_UserParameter0,
                         ColumnName_UserParameter1,
                         ColumnName_UserParameter2,
                         ColumnName_UserParameter3,

                         ColumnName_UserParameters[0,0],
                         ColumnName_UserParameters[0,1],
                         ColumnName_UserParameters[0,2],
                         ColumnName_UserParameters[0,3],
                         ColumnName_UserParameters[0,4],
                         ColumnName_UserParameters[0,5],
                         ColumnName_UserParameters[0,6],
                         ColumnName_UserParameters[0,7],
                         ColumnName_UserParameters[0,8],
                         ColumnName_UserParameters[0,9],
                         ColumnName_UserParameters[0,10],
                         ColumnName_UserParameters[0,11],
                         ColumnName_UserParameters[0,12],
                         ColumnName_UserParameters[0,13],
                         ColumnName_UserParameters[0,14],
                         ColumnName_UserParameters[0,15],
                         ColumnName_UserParameters[0,16],
                         ColumnName_UserParameters[0,17],
                         ColumnName_UserParameters[0,18],
                         ColumnName_UserParameters[0,19],
                         ColumnName_UserParameters[0,20],
                         ColumnName_UserParameters[0,21],
                         ColumnName_UserParameters[0,22],
                         ColumnName_UserParameters[0,23],
                         ColumnName_UserParameters[0,24],
                         ColumnName_UserParameters[0,25],
                         ColumnName_UserParameters[0,26],
                         ColumnName_UserParameters[0,27],
                         ColumnName_UserParameters[0,28],
                         ColumnName_UserParameters[0,29],
                         ColumnName_UserParameters[0,30],
                         ColumnName_UserParameters[0,31],
                         ColumnName_UserParameters[1,0],
                         ColumnName_UserParameters[1,1],
                         ColumnName_UserParameters[1,2],
                         ColumnName_UserParameters[1,3],
                         ColumnName_UserParameters[1,4],
                         ColumnName_UserParameters[1,5],
                         ColumnName_UserParameters[1,6],
                         ColumnName_UserParameters[1,7],
                         ColumnName_UserParameters[1,8],
                         ColumnName_UserParameters[1,9],
                         ColumnName_UserParameters[1,10],
                         ColumnName_UserParameters[1,11],
                         ColumnName_UserParameters[1,12],
                         ColumnName_UserParameters[1,13],
                         ColumnName_UserParameters[1,14],
                         ColumnName_UserParameters[1,15],
                         ColumnName_UserParameters[1,16],
                         ColumnName_UserParameters[1,17],
                         ColumnName_UserParameters[1,18],
                         ColumnName_UserParameters[1,19],
                         ColumnName_UserParameters[1,20],
                         ColumnName_UserParameters[1,21],
                         ColumnName_UserParameters[1,22],
                         ColumnName_UserParameters[1,23],
                         ColumnName_UserParameters[1,24],
                         ColumnName_UserParameters[1,25],
                         ColumnName_UserParameters[1,26],
                         ColumnName_UserParameters[1,27],
                         ColumnName_UserParameters[1,28],
                         ColumnName_UserParameters[1,29],
                         ColumnName_UserParameters[1,30],
                         ColumnName_UserParameters[1,31],
                         ColumnName_UserParameters[2,0],
                         ColumnName_UserParameters[2,1],
                         ColumnName_UserParameters[2,2],
                         ColumnName_UserParameters[2,3],
                         ColumnName_UserParameters[2,4],
                         ColumnName_UserParameters[2,5],
                         ColumnName_UserParameters[2,6],
                         ColumnName_UserParameters[2,7],
                         ColumnName_UserParameters[2,8],
                         ColumnName_UserParameters[2,9],
                         ColumnName_UserParameters[2,10],
                         ColumnName_UserParameters[2,11],
                         ColumnName_UserParameters[2,12],
                         ColumnName_UserParameters[2,13],
                         ColumnName_UserParameters[2,14],
                         ColumnName_UserParameters[2,15],
                         ColumnName_UserParameters[2,16],
                         ColumnName_UserParameters[2,17],
                         ColumnName_UserParameters[2,18],
                         ColumnName_UserParameters[2,19],
                         ColumnName_UserParameters[2,20],
                         ColumnName_UserParameters[2,21],
                         ColumnName_UserParameters[2,22],
                         ColumnName_UserParameters[2,23],
                         ColumnName_UserParameters[2,24],
                         ColumnName_UserParameters[2,25],
                         ColumnName_UserParameters[2,26],
                         ColumnName_UserParameters[2,27],
                         ColumnName_UserParameters[2,28],
                         ColumnName_UserParameters[2,29],
                         ColumnName_UserParameters[2,30],
                         ColumnName_UserParameters[2,31],
                         ColumnName_UserParameters[3,0],
                         ColumnName_UserParameters[3,1],
                         ColumnName_UserParameters[3,2],
                         ColumnName_UserParameters[3,3],
                         ColumnName_UserParameters[3,4],
                         ColumnName_UserParameters[3,5],
                         ColumnName_UserParameters[3,6],
                         ColumnName_UserParameters[3,7],
                         ColumnName_UserParameters[3,8],
                         ColumnName_UserParameters[3,9],
                         ColumnName_UserParameters[3,10],
                         ColumnName_UserParameters[3,11],
                         ColumnName_UserParameters[3,12],
                         ColumnName_UserParameters[3,13],
                         ColumnName_UserParameters[3,14],
                         ColumnName_UserParameters[3,15],
                         ColumnName_UserParameters[3,16],
                         ColumnName_UserParameters[3,17],
                         ColumnName_UserParameters[3,18],
                         ColumnName_UserParameters[3,19],
                         ColumnName_UserParameters[3,20],
                         ColumnName_UserParameters[3,21],
                         ColumnName_UserParameters[3,22],
                         ColumnName_UserParameters[3,23],
                         ColumnName_UserParameters[3,24],
                         ColumnName_UserParameters[3,25],
                         ColumnName_UserParameters[3,26],
                         ColumnName_UserParameters[3,27],
                         ColumnName_UserParameters[3,28],
                         ColumnName_UserParameters[3,29],
                         ColumnName_UserParameters[3,30],
                         ColumnName_UserParameters[3,31],

                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                   });

            AddList(ListName_SequenceSoundSet,
                    new string[] {
                         ColumnName_Name,
                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_SequenceSoundSetItem,
                    new string[] {
                         ColumnName_SndEdit,
                         ColumnName_PreviewPlay,
                         ColumnName_Name,
                         ColumnName_SinglePlayType,
                         ColumnName_SinglePlayEffectiveDuration,
                         ColumnName_FileType,
                         ColumnName_FilePath,
                         ColumnName_StartPosition,
                         ColumnName_SoundSetBankReferences,
                         ColumnName_PlayerReference,
                         ColumnName_Volume,
                         ColumnName_IntegratedLoudness,
                         ColumnName_ChannelPriority,
                         ColumnName_PlayerPriority,
                         ColumnName_ActorPlayer,
                         ColumnName_ReleasePriorityFixed,
                         ColumnName_Enable3DVolume,
                         ColumnName_Enable3DPan,
                         ColumnName_Enable3DSurroundPan,
                         ColumnName_Enable3DPriority,
                         ColumnName_Enable3DFilter,
                         ColumnName_DecayCurve3D,
                         ColumnName_DecayRatio3D,
                         ColumnName_DopplerFactor3D,
                         ColumnName_FrontBypass,
                         ColumnName_MaximumVoiceCount,

                         ColumnName_UserParameter0,
                         ColumnName_UserParameter1,
                         ColumnName_UserParameter2,
                         ColumnName_UserParameter3,

                         ColumnName_UserParameters[0,0],
                         ColumnName_UserParameters[0,1],
                         ColumnName_UserParameters[0,2],
                         ColumnName_UserParameters[0,3],
                         ColumnName_UserParameters[0,4],
                         ColumnName_UserParameters[0,5],
                         ColumnName_UserParameters[0,6],
                         ColumnName_UserParameters[0,7],
                         ColumnName_UserParameters[0,8],
                         ColumnName_UserParameters[0,9],
                         ColumnName_UserParameters[0,10],
                         ColumnName_UserParameters[0,11],
                         ColumnName_UserParameters[0,12],
                         ColumnName_UserParameters[0,13],
                         ColumnName_UserParameters[0,14],
                         ColumnName_UserParameters[0,15],
                         ColumnName_UserParameters[0,16],
                         ColumnName_UserParameters[0,17],
                         ColumnName_UserParameters[0,18],
                         ColumnName_UserParameters[0,19],
                         ColumnName_UserParameters[0,20],
                         ColumnName_UserParameters[0,21],
                         ColumnName_UserParameters[0,22],
                         ColumnName_UserParameters[0,23],
                         ColumnName_UserParameters[0,24],
                         ColumnName_UserParameters[0,25],
                         ColumnName_UserParameters[0,26],
                         ColumnName_UserParameters[0,27],
                         ColumnName_UserParameters[0,28],
                         ColumnName_UserParameters[0,29],
                         ColumnName_UserParameters[0,30],
                         ColumnName_UserParameters[0,31],
                         ColumnName_UserParameters[1,0],
                         ColumnName_UserParameters[1,1],
                         ColumnName_UserParameters[1,2],
                         ColumnName_UserParameters[1,3],
                         ColumnName_UserParameters[1,4],
                         ColumnName_UserParameters[1,5],
                         ColumnName_UserParameters[1,6],
                         ColumnName_UserParameters[1,7],
                         ColumnName_UserParameters[1,8],
                         ColumnName_UserParameters[1,9],
                         ColumnName_UserParameters[1,10],
                         ColumnName_UserParameters[1,11],
                         ColumnName_UserParameters[1,12],
                         ColumnName_UserParameters[1,13],
                         ColumnName_UserParameters[1,14],
                         ColumnName_UserParameters[1,15],
                         ColumnName_UserParameters[1,16],
                         ColumnName_UserParameters[1,17],
                         ColumnName_UserParameters[1,18],
                         ColumnName_UserParameters[1,19],
                         ColumnName_UserParameters[1,20],
                         ColumnName_UserParameters[1,21],
                         ColumnName_UserParameters[1,22],
                         ColumnName_UserParameters[1,23],
                         ColumnName_UserParameters[1,24],
                         ColumnName_UserParameters[1,25],
                         ColumnName_UserParameters[1,26],
                         ColumnName_UserParameters[1,27],
                         ColumnName_UserParameters[1,28],
                         ColumnName_UserParameters[1,29],
                         ColumnName_UserParameters[1,30],
                         ColumnName_UserParameters[1,31],
                         ColumnName_UserParameters[2,0],
                         ColumnName_UserParameters[2,1],
                         ColumnName_UserParameters[2,2],
                         ColumnName_UserParameters[2,3],
                         ColumnName_UserParameters[2,4],
                         ColumnName_UserParameters[2,5],
                         ColumnName_UserParameters[2,6],
                         ColumnName_UserParameters[2,7],
                         ColumnName_UserParameters[2,8],
                         ColumnName_UserParameters[2,9],
                         ColumnName_UserParameters[2,10],
                         ColumnName_UserParameters[2,11],
                         ColumnName_UserParameters[2,12],
                         ColumnName_UserParameters[2,13],
                         ColumnName_UserParameters[2,14],
                         ColumnName_UserParameters[2,15],
                         ColumnName_UserParameters[2,16],
                         ColumnName_UserParameters[2,17],
                         ColumnName_UserParameters[2,18],
                         ColumnName_UserParameters[2,19],
                         ColumnName_UserParameters[2,20],
                         ColumnName_UserParameters[2,21],
                         ColumnName_UserParameters[2,22],
                         ColumnName_UserParameters[2,23],
                         ColumnName_UserParameters[2,24],
                         ColumnName_UserParameters[2,25],
                         ColumnName_UserParameters[2,26],
                         ColumnName_UserParameters[2,27],
                         ColumnName_UserParameters[2,28],
                         ColumnName_UserParameters[2,29],
                         ColumnName_UserParameters[2,30],
                         ColumnName_UserParameters[2,31],
                         ColumnName_UserParameters[3,0],
                         ColumnName_UserParameters[3,1],
                         ColumnName_UserParameters[3,2],
                         ColumnName_UserParameters[3,3],
                         ColumnName_UserParameters[3,4],
                         ColumnName_UserParameters[3,5],
                         ColumnName_UserParameters[3,6],
                         ColumnName_UserParameters[3,7],
                         ColumnName_UserParameters[3,8],
                         ColumnName_UserParameters[3,9],
                         ColumnName_UserParameters[3,10],
                         ColumnName_UserParameters[3,11],
                         ColumnName_UserParameters[3,12],
                         ColumnName_UserParameters[3,13],
                         ColumnName_UserParameters[3,14],
                         ColumnName_UserParameters[3,15],
                         ColumnName_UserParameters[3,16],
                         ColumnName_UserParameters[3,17],
                         ColumnName_UserParameters[3,18],
                         ColumnName_UserParameters[3,19],
                         ColumnName_UserParameters[3,20],
                         ColumnName_UserParameters[3,21],
                         ColumnName_UserParameters[3,22],
                         ColumnName_UserParameters[3,23],
                         ColumnName_UserParameters[3,24],
                         ColumnName_UserParameters[3,25],
                         ColumnName_UserParameters[3,26],
                         ColumnName_UserParameters[3,27],
                         ColumnName_UserParameters[3,28],
                         ColumnName_UserParameters[3,29],
                         ColumnName_UserParameters[3,30],
                         ColumnName_UserParameters[3,31],

                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_SequenceSound,
                    new string[] {
                         ColumnName_SndEdit,
                         ColumnName_PreviewPlay,
                         ColumnName_Name,
                         ColumnName_SinglePlayType,
                         ColumnName_SinglePlayEffectiveDuration,
                         ColumnName_FileType,
                         ColumnName_FilePath,
                         ColumnName_StartPosition,

                             // @@@
                         //ColumnName_SoundSetBankReferences,
                         ColumnName_SoundSetBankReference0,
                         ColumnName_SoundSetBankReference1,
                         ColumnName_SoundSetBankReference2,
                         ColumnName_SoundSetBankReference3,

                         ColumnName_PlayerReference,
                         ColumnName_Volume,
                         ColumnName_IntegratedLoudness,
                         ColumnName_ChannelPriority,
                         ColumnName_PlayerPriority,
                         ColumnName_ActorPlayer,
                         ColumnName_ReleasePriorityFixed,
                         ColumnName_Enable3DVolume,
                         ColumnName_Enable3DPan,
                         ColumnName_Enable3DSurroundPan,
                         ColumnName_Enable3DPriority,
                         ColumnName_Enable3DFilter,
                         ColumnName_DecayCurve3D,
                         ColumnName_DecayRatio3D,
                         ColumnName_DopplerFactor3D,
                         ColumnName_FrontBypass,

                         ColumnName_UserParameter0,
                         ColumnName_UserParameter1,
                         ColumnName_UserParameter2,
                         ColumnName_UserParameter3,

                         ColumnName_UserParameters[0,0],
                         ColumnName_UserParameters[0,1],
                         ColumnName_UserParameters[0,2],
                         ColumnName_UserParameters[0,3],
                         ColumnName_UserParameters[0,4],
                         ColumnName_UserParameters[0,5],
                         ColumnName_UserParameters[0,6],
                         ColumnName_UserParameters[0,7],
                         ColumnName_UserParameters[0,8],
                         ColumnName_UserParameters[0,9],
                         ColumnName_UserParameters[0,10],
                         ColumnName_UserParameters[0,11],
                         ColumnName_UserParameters[0,12],
                         ColumnName_UserParameters[0,13],
                         ColumnName_UserParameters[0,14],
                         ColumnName_UserParameters[0,15],
                         ColumnName_UserParameters[0,16],
                         ColumnName_UserParameters[0,17],
                         ColumnName_UserParameters[0,18],
                         ColumnName_UserParameters[0,19],
                         ColumnName_UserParameters[0,20],
                         ColumnName_UserParameters[0,21],
                         ColumnName_UserParameters[0,22],
                         ColumnName_UserParameters[0,23],
                         ColumnName_UserParameters[0,24],
                         ColumnName_UserParameters[0,25],
                         ColumnName_UserParameters[0,26],
                         ColumnName_UserParameters[0,27],
                         ColumnName_UserParameters[0,28],
                         ColumnName_UserParameters[0,29],
                         ColumnName_UserParameters[0,30],
                         ColumnName_UserParameters[0,31],
                         ColumnName_UserParameters[1,0],
                         ColumnName_UserParameters[1,1],
                         ColumnName_UserParameters[1,2],
                         ColumnName_UserParameters[1,3],
                         ColumnName_UserParameters[1,4],
                         ColumnName_UserParameters[1,5],
                         ColumnName_UserParameters[1,6],
                         ColumnName_UserParameters[1,7],
                         ColumnName_UserParameters[1,8],
                         ColumnName_UserParameters[1,9],
                         ColumnName_UserParameters[1,10],
                         ColumnName_UserParameters[1,11],
                         ColumnName_UserParameters[1,12],
                         ColumnName_UserParameters[1,13],
                         ColumnName_UserParameters[1,14],
                         ColumnName_UserParameters[1,15],
                         ColumnName_UserParameters[1,16],
                         ColumnName_UserParameters[1,17],
                         ColumnName_UserParameters[1,18],
                         ColumnName_UserParameters[1,19],
                         ColumnName_UserParameters[1,20],
                         ColumnName_UserParameters[1,21],
                         ColumnName_UserParameters[1,22],
                         ColumnName_UserParameters[1,23],
                         ColumnName_UserParameters[1,24],
                         ColumnName_UserParameters[1,25],
                         ColumnName_UserParameters[1,26],
                         ColumnName_UserParameters[1,27],
                         ColumnName_UserParameters[1,28],
                         ColumnName_UserParameters[1,29],
                         ColumnName_UserParameters[1,30],
                         ColumnName_UserParameters[1,31],
                         ColumnName_UserParameters[2,0],
                         ColumnName_UserParameters[2,1],
                         ColumnName_UserParameters[2,2],
                         ColumnName_UserParameters[2,3],
                         ColumnName_UserParameters[2,4],
                         ColumnName_UserParameters[2,5],
                         ColumnName_UserParameters[2,6],
                         ColumnName_UserParameters[2,7],
                         ColumnName_UserParameters[2,8],
                         ColumnName_UserParameters[2,9],
                         ColumnName_UserParameters[2,10],
                         ColumnName_UserParameters[2,11],
                         ColumnName_UserParameters[2,12],
                         ColumnName_UserParameters[2,13],
                         ColumnName_UserParameters[2,14],
                         ColumnName_UserParameters[2,15],
                         ColumnName_UserParameters[2,16],
                         ColumnName_UserParameters[2,17],
                         ColumnName_UserParameters[2,18],
                         ColumnName_UserParameters[2,19],
                         ColumnName_UserParameters[2,20],
                         ColumnName_UserParameters[2,21],
                         ColumnName_UserParameters[2,22],
                         ColumnName_UserParameters[2,23],
                         ColumnName_UserParameters[2,24],
                         ColumnName_UserParameters[2,25],
                         ColumnName_UserParameters[2,26],
                         ColumnName_UserParameters[2,27],
                         ColumnName_UserParameters[2,28],
                         ColumnName_UserParameters[2,29],
                         ColumnName_UserParameters[2,30],
                         ColumnName_UserParameters[2,31],
                         ColumnName_UserParameters[3,0],
                         ColumnName_UserParameters[3,1],
                         ColumnName_UserParameters[3,2],
                         ColumnName_UserParameters[3,3],
                         ColumnName_UserParameters[3,4],
                         ColumnName_UserParameters[3,5],
                         ColumnName_UserParameters[3,6],
                         ColumnName_UserParameters[3,7],
                         ColumnName_UserParameters[3,8],
                         ColumnName_UserParameters[3,9],
                         ColumnName_UserParameters[3,10],
                         ColumnName_UserParameters[3,11],
                         ColumnName_UserParameters[3,12],
                         ColumnName_UserParameters[3,13],
                         ColumnName_UserParameters[3,14],
                         ColumnName_UserParameters[3,15],
                         ColumnName_UserParameters[3,16],
                         ColumnName_UserParameters[3,17],
                         ColumnName_UserParameters[3,18],
                         ColumnName_UserParameters[3,19],
                         ColumnName_UserParameters[3,20],
                         ColumnName_UserParameters[3,21],
                         ColumnName_UserParameters[3,22],
                         ColumnName_UserParameters[3,23],
                         ColumnName_UserParameters[3,24],
                         ColumnName_UserParameters[3,25],
                         ColumnName_UserParameters[3,26],
                         ColumnName_UserParameters[3,27],
                         ColumnName_UserParameters[3,28],
                         ColumnName_UserParameters[3,29],
                         ColumnName_UserParameters[3,30],
                         ColumnName_UserParameters[3,31],

                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_Bank,
                    new string[] {
                         ColumnName_SndEdit,
                         ColumnName_Name,
                         ColumnName_WaveArchiveReference,
                         ColumnName_FilePath,
                         ColumnName_DataSize,
                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_WaveArchive,
                     new string[] {
                         ColumnName_Name,
                         ColumnName_WaveArchiveLoadType,
                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                     });

            AddList(ListName_Player,
                    new string[] {
                         ColumnName_Name,
                         ColumnName_PlayerSoundLimit,
                         ColumnName_PlayerHeapSize,
                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_Group,
                    new string[] {
                         ColumnName_Name,
                         ColumnName_DataSize,
                         ColumnName_GroupOutputType,
                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_GroupItem,
                    new string[] {
                         ColumnName_GroupItemTargetName,
                         ColumnName_GroupItemRegisterType,
                         ColumnName_GroupItemTargetSoundSet,
                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_Instrument,
                    new string[] {
                         ColumnName_ProgramNo,
                         ColumnName_Name,
                         ColumnName_WaveEncoding,
                         ColumnName_FilePath,
                         ColumnName_WaveTime,
                         ColumnName_WaveTick,
                         ColumnName_IsResampleEnabled,
                         ColumnName_SampleRate,
                         ColumnName_WaveBitRate,
                         ColumnName_WaveSampleBit,
                         ColumnName_IsDownMixEnabled,
                         ColumnName_WaveChannel,
                         ColumnName_DataSize,

                         ColumnName_OriginalKey,
                         ColumnName_EnvelopeAttack,
                         ColumnName_EnvelopeHold,
                         ColumnName_EnvelopeDecay,
                         ColumnName_EnvelopeSustain,
                         ColumnName_EnvelopeRelease,
                         ColumnName_Volume,
                         ColumnName_PitchSemitones,
                         ColumnName_PitchCents,
                         ColumnName_InterpolationType,
                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_Percussion,
                    new string[] {
                         ColumnName_WaveEncoding,
                         ColumnName_FilePath,
                         ColumnName_WaveTime,
                         ColumnName_WaveTick,
                         ColumnName_SampleRate,
                         ColumnName_WaveBitRate,
                         ColumnName_WaveSampleBit,
                         ColumnName_WaveChannel,
                         ColumnName_DataSize,

                         ColumnName_OriginalKey,
                         ColumnName_EnvelopeAttack,
                         ColumnName_EnvelopeHold,
                         ColumnName_EnvelopeDecay,
                         ColumnName_EnvelopeSustain,
                         ColumnName_EnvelopeRelease,
                         ColumnName_Volume,
                         ColumnName_PitchSemitones,
                         ColumnName_PitchCents,
                         ColumnName_Pan,
                         ColumnName_PercussionMode,
                         ColumnName_KeyGroup,
                         ColumnName_InterpolationType,
                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_FindResult,
                    new string[] {
                         ColumnName_Name,
                         ColumnName_ItemLocation,
                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_MultipleBank,
                    new string[] {
                         ColumnName_SoundSetBankReferences,
                    });

            AddList(ListName_History,
                    new string[] {
                    ColumnName_Name,
                    ColumnName_DateTime,
                    });

            AddList(ListName_MeasureReferenceCountFilePath,
                     new string[] {
                         ColumnName_FilePath,
                         ColumnName_ReferenceCount,
                     });

            AddList(ListName_MeasureReferenceCountInstrument,
                     new string[] {
                         ColumnName_Name,
                         ColumnName_ReferenceCount,
                         ColumnName_FilePath,
                     });

            AddList(ListName_SndEdit,
                    new string[] {
                    ColumnName_SndEdit,
                    ColumnName_SndEditEnabled,
                    ColumnName_PreviewPlay,
                    ColumnName_Name,
                    });
        }

        protected virtual void InitializeColumns()
        {
            AddColumn(
                new ListColumnTrait(ColumnName_DecayCurve3D,
                                     MessageResource.HeaderText_3DDecayCurve,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_DecayRatio3D,
                                     MessageResource.HeaderText_3DDecayRatio,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_DopplerFactor3D,
                                     MessageResource.HeaderText_3DDopplerFactor,
                                     88, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_Enable3DFilter,
                                     MessageResource.HeaderText_Enable3DFilter,
                                     40, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_Enable3DPan,
                                     MessageResource.HeaderText_Enable3DPan,
                                     32, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_Enable3DPriority,
                                     MessageResource.HeaderText_Enable3DPriority,
                                     32, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_Enable3DSurroundPan,
                                     MessageResource.HeaderText_Enable3DSurroundPan,
                                     32, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_Enable3DVolume,
                                     MessageResource.HeaderText_Enable3DVolume,
                                     32, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_ActorPlayer,
                                     MessageResource.HeaderText_ActorPlayer,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_AuxASend,
                                     MessageResource.HeaderText_AuxASend,
                                     48, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_AuxBSend,
                                     MessageResource.HeaderText_AuxBSend,
                                     48, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_MainSend,
                                     MessageResource.HeaderText_MainSend,
                                     60, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_SoundSetBankReferences,
                                     MessageResource.HeaderText_Bank,
                                     128, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
#if true
            // @@@
            AddColumn(new ListColumnTrait(ColumnName_SoundSetBankReference0,
                                            MessageResource.HeaderText_Bank0,
                                            128, 32,
                                            ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(new ListColumnTrait(ColumnName_SoundSetBankReference1,
                                            MessageResource.HeaderText_Bank1,
                                            128, 32,
                                            ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(new ListColumnTrait(ColumnName_SoundSetBankReference2,
                                            MessageResource.HeaderText_Bank2,
                                            128, 32,
                                            ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(new ListColumnTrait(ColumnName_SoundSetBankReference3,
                                            MessageResource.HeaderText_Bank3,
                                            128, 32,
                                            ListColumnTrait.HorizontalAlignment.Left));
#endif
            AddColumn(
                new ListColumnTrait(ColumnName_ChannelPriority,
                                     MessageResource.HeaderText_ChannelPriority,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_Comment,
                                     MessageResource.HeaderText_Comment,
                                     256, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_Comment1,
                                     MessageResource.HeaderText_Comment1,
                                     256, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_Comment2,
                                     MessageResource.HeaderText_Comment2,
                                     256, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_Comment3,
                                     MessageResource.HeaderText_Comment3,
                                     256, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_Comment4,
                                     MessageResource.HeaderText_Comment4,
                                     256, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_Comment5,
                                     MessageResource.HeaderText_Comment5,
                                     256, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_Comment6,
                                     MessageResource.HeaderText_Comment6,
                                     256, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_Comment7,
                                     MessageResource.HeaderText_Comment7,
                                     256, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_Comment8,
                                     MessageResource.HeaderText_Comment8,
                                     256, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_Comment9,
                                     MessageResource.HeaderText_Comment9,
                                     256, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_DataSize,
                                     MessageResource.HeaderText_DataSize,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_EnvelopeAttack,
                                     MessageResource.HeaderText_EnvelopeAttack,
                                     32, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_EnvelopeDecay,
                                     MessageResource.HeaderText_EnvelopeDecay,
                                     32, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_EnvelopeHold,
                                     MessageResource.HeaderText_EnvelopeHold,
                                     32, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_EnvelopeRelease,
                                     MessageResource.HeaderText_EnvelopeRelease,
                                     32, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_EnvelopeSustain,
                                     MessageResource.HeaderText_EnvelopeSustain,
                                     32, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_FilePath,
                                     MessageResource.HeaderText_FilePath,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_FileType,
                                     MessageResource.HeaderText_FileType,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_GroupOutputType,
                                     MessageResource.HeaderText_GroupOutputType,
                                     192, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_GroupItemTargetName,
                                     MessageResource.HeaderText_GroupItemTargetName,
                                     192, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_GroupItemTargetSoundSet,
                                     MessageResource.HeaderText_GroupItemTargetSoundSet,
                                     192, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_ItemIndex,
                                     MessageResource.HeaderText_ItemIndex,
                                     48, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_ItemLocation,
                                     MessageResource.HeaderText_ItemLocation,
                                     128, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_ItemType,
                                     MessageResource.HeaderText_ItemType,
                                     48, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_KeyGroup,
                                     MessageResource.HeaderText_KeyGroup,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_Name,
                                     MessageResource.HeaderText_Name,
                                     128, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_OriginalKey,
                                     MessageResource.HeaderText_OriginalKey,
                                     76, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_Pan,
                                     MessageResource.HeaderText_Pan,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_PanCurve,
                                     MessageResource.HeaderText_PanCurve,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_PanMode,
                                     MessageResource.HeaderText_PanMode,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_PercussionMode,
                                     MessageResource.HeaderText_PercussionMode,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_Pitch,
                                     MessageResource.HeaderText_Pitch,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_PitchCents,
                                     MessageResource.HeaderText_PitchCents,
                                     72, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_PitchSemitones,
                                     MessageResource.HeaderText_PitchSemitones,
                                     72, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_PlayerReference,
                                     MessageResource.HeaderText_Player,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_PlayerHeapSize,
                                     MessageResource.HeaderText_PlayerHeapSize,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_PlayerPriority,
                                     MessageResource.HeaderText_PlayerPriority,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_PlayerSoundLimit,
                                     MessageResource.HeaderText_PlayerSoundLimit,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_ProgramNo,
                                     MessageResource.HeaderText_ProgramNo,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_ReleasePriorityFixed,
                                     MessageResource.HeaderText_ReleasePriorityFixed,
                                     80, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_StartPosition,
                                     MessageResource.HeaderText_StartPosition,
                                     80, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_SurroundPan,
                                     MessageResource.HeaderText_SurroundPan,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_UserParameter0,
                                     MessageResource.HeaderText_UserParameter,
                                     72, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));

            AddColumn(
                new ListColumnTrait(ColumnName_UserParameter1,
                                     MessageResource.HeaderText_UserParameter1,
                                     72, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_UserParameter2,
                                     MessageResource.HeaderText_UserParameter2,
                                     72, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_UserParameter3,
                                     MessageResource.HeaderText_UserParameter3,
                                     72, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));

            AddColumn(
                new ListColumnTrait(ColumnName_Volume,
                                     MessageResource.HeaderText_Volume,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_IntegratedLoudness,
                                     MessageResource.HeaderText_IntegratedLoudness,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_WaveEncoding,
                                     MessageResource.HeaderText_WaveEncoding,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_WaveArchiveLoadType,
                                     MessageResource.HeaderText_WaveArchiveLoadType,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                  new ListColumnTrait(ColumnName_WaveArchiveReference,
                                       MessageResource.HeaderText_WaveArchiveReference,
                                       64, 32,
                                       ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_WaveSoundEnvelopeRelease,
                                     MessageResource.HeaderText_EnvelopeRelease,
                                     32, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));

            AddColumn(
                new ListColumnTrait(ColumnName_PreviewPlay,
                                     MessageResource.HeaderText_PreviewPlay,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_PreviewMute,
                                     MessageResource.HeaderText_PreviewMute,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_PreviewSoloPlay,
                                     MessageResource.HeaderText_PreviewSoloPlay,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));

            AddColumn(
                new ListColumnTrait(ColumnName_GroupItemRegisterType,
                                     MessageResource.HeaderText_GroupItemRegisterType,
                                     128, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_WaveTime,
                                     MessageResource.HeaderText_WaveTime,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_WaveTick,
                                     MessageResource.HeaderText_WaveTick,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                      new ListColumnTrait(ColumnName_IsPrefetchEnabled,
                                          MessageResource.HeaderText_IsPrefetchEnabled,
                                          60, 40,
                                          ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                      new ListColumnTrait(ColumnName_IsResampleEnabled,
                                          MessageResource.HeaderText_IsResampleEnabled,
                                          64, 40,
                                          ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                      new ListColumnTrait(ColumnName_SampleRate,
                                          MessageResource.HeaderText_SampleRate,
                                          64, 54,
                                          ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                      new ListColumnTrait(ColumnName_WaveBitRate,
                                          MessageResource.HeaderText_WaveBitRate,
                                          64, 54,
                                          ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                      new ListColumnTrait(ColumnName_WaveSampleBit,
                                          MessageResource.HeaderText_WaveSampleBit,
                                          64, 54,
                                          ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                      new ListColumnTrait(ColumnName_IsDownMixEnabled,
                                          MessageResource.HeaderText_IsDownMixEnabled,
                                          64, 40,
                                          ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                      new ListColumnTrait(ColumnName_WaveChannel,
                                          MessageResource.HeaderText_WaveChannel,
                                          64, 54,
                                          ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_InterpolationType,
                                     MessageResource.HeaderText_InterpolationType,
                                     32, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_FrontBypass,
                                     MessageResource.HeaderText_FrontBypass,
                                     32, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_LPF,
                                     MessageResource.HeaderText_LPF,
                                     32, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));

            AddColumn(
                new ListColumnTrait(ColumnName_BiquadType,
                                     MessageResource.HeaderText_BiquadType,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));

            AddColumn(
                new ListColumnTrait(ColumnName_Biquad,
                                     MessageResource.HeaderText_Biquad,
                                     32, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_TrackNo,
                                     MessageResource.HeaderText_TrackNo,
                                     32, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_ChannelNo,
                                     MessageResource.HeaderText_ChannelNo,
                                     32, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_DateTime,
                                     MessageResource.HeaderText_DateTime,
                                     64, 40,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_ReferenceCount,
                                     MessageResource.HeaderText_ReferenceCount,
                                     64, 40,
                                     ListColumnTrait.HorizontalAlignment.Right));
            AddColumn(
                new ListColumnTrait(ColumnName_TrackVolume,
                                     MessageResource.HeaderText_TrackVolume,
                                     64, 32,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_TrackMainSend,
                                     MessageResource.HeaderText_TrackMainSend,
                                     48, 48,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_TrackAuxASend,
                                     MessageResource.HeaderText_TrackAuxASend,
                                     48, 48,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_TrackAuxBSend,
                                     MessageResource.HeaderText_TrackAuxBSend,
                                     48, 48,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                new ListColumnTrait(ColumnName_MaximumVoiceCount,
                                     MessageResource.HeaderText_MaximumVoiceCount,
                                     48, 48,
                                     ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                      new ListColumnTrait(ColumnName_SndEdit,
                                           MessageResource.HeaderText_SndEdit,
                                           64, 40,
                                           ListColumnTrait.HorizontalAlignment.Left));

            AddColumn(
                      new ListColumnTrait(ColumnName_SndEditEnabled,
                                           MessageResource.HeaderText_SndEditEnabled,
                                           40, 40,
                                           ListColumnTrait.HorizontalAlignment.Left));

            // 単一再生の種類
            AddColumn(new ListColumnTrait(ColumnName_SinglePlayType,
                                          MessageResource.HeaderText_SinglePlayType,
                                          64, 54,
                                          ListColumnTrait.HorizontalAlignment.Left));

            // 単一再生の有効時間
            AddColumn(new ListColumnTrait(ColumnName_SinglePlayEffectiveDuration,
                                          MessageResource.HeaderText_SinglePlayEffectiveDuration,
                                          64, 54,
                                          ListColumnTrait.HorizontalAlignment.Left));

            for (int i = 0; i <= 3; i++)
            {
                for (int j = 0; j < 32; j++)
                {
                    AddColumn(new ListColumnTrait("UserParameter_" + i + "_" + j,
                                                  string.Empty,
                                                  32, 32,
                                                  ListColumnTrait.HorizontalAlignment.Left));
                }
            }
        }

        protected void AddList(string name, string[] columnNames)
        {
            Debug.Assert(null != name, "unexpected error");
            Debug.Assert(null != columnNames, "unexpected error");

#if DEBUG
            foreach ( string columnName in columnNames ) {

                if ( !_columns.ContainsKey( columnName ) ) {
                    Debug.Fail( "unknown column" );
                    continue;
                }

            }
#endif

            _listTraits.Add(name, new ListTrait(name, columnNames));
        }

        protected void AddColumn(ListColumnTrait trait)
        {
            Debug.Assert(null != trait, "unexpected error");
            _columns.Add(trait.Name, trait);
        }

        #region ** 内部用コレクションクラス

        private class ListTraitDictionary :
            Dictionary<string, ListTrait>,
            IReadOnlyDictionary<string, ListTrait>
        {
        }

        private class ListColumnDictionary :
            Dictionary<string, ListColumnTrait>,
            IReadOnlyDictionary<string, ListColumnTrait>
        {
        }

        private class ListType2NameDictionary :
            Dictionary<Type, string>,
            IReadOnlyDictionary<Type, string>
        {
        }

        private class StringCollection : KeyedCollection<string, string>
        {
            protected override string GetKeyForItem(string item)
            {
                return item;
            }
        }

        #endregion
    }
}
