﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Commands
{
    using System.Collections.Generic;
    using System.Reflection;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core.Reflection;
    using NintendoWare.SoundMaker.Framework.Resources;

    /// <summary>
    /// インストルメントリスト関連コマンドを管理します。
    /// </summary>
    public static class InstrumentListCommands
    {
        /// <summary>
        /// インストルメントリスト関連コマンドを列挙する IEnumerable を取得します。
        /// </summary>
        public static IEnumerable<Command> Commands
        {
            get
            {
                return ObjectFinder.FindStaticValues<Command>(typeof(InstrumentListCommands),
                                                               BindingFlags.GetProperty | BindingFlags.GetField);
            }
        }

        /// <summary>
        /// インストルメントの追加。
        /// </summary>
        public static readonly Command AddInstrument =
            new Command("InstrumentList.AddInstrument", string.Empty);

        /// <summary>
        /// インストルメントの挿入。
        /// </summary>
        public static readonly Command InsertInstrument =
            new Command("InstrumentList.InsertInstrument", string.Empty);

        /// <summary>
        /// リージョン単位でエンベロープを指定する。
        /// </summary>
        public static readonly Command SetEnvelopeToRegion =
            new Command("InstrumentList.SetEnvelopeToRegion", string.Empty)
            {
#if false
                Text = MessageResource.Command_InstrumentList_SetEnvelopeToRegion_Text,
#endif
            };

        /// <summary>
        /// インストルメント単位でエンベロープを指定する。
        /// </summary>
        public static readonly Command SetEnvelopeToInstrument =
            new Command("InstrumentList.SetEnvelopeToInstrument", string.Empty)
            {
#if false
                Text = MessageResource.Command_InstrumentList_SetEnvelopeToInstrument_Text,
#endif
            };
    }
}
