﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.CommandHandlers
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Diagnostics;
    using System.IO;
    using System.Linq;
    using System.Windows.Forms;
    using NintendoWare.SoundFoundation.CommandHandlers;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Framework.CommandHandlers;
    using NintendoWare.SoundMaker.Framework.Commands;
    using NintendoWare.SoundMaker.Framework.Configurations.Schemas;
    using NintendoWare.SoundMaker.Framework.Windows.Forms;
    using NintendoWare.SoundMaker.Framework.Resources;
    using NintendoWare.SoundMaker.Preview;
    using NintendoWare.SoundMaker.Profile;
    using FrameworkResources = NintendoWare.SoundMaker.Framework.Resources;

    /// <summary>
    /// シーケンスサウンドの最大発音数を計測コマンドを処理します。
    /// </summary>
    public class QueryAndMeasureSequenceVoiceCountHandler : QueryAndMeasureHandler
    {
        private int measureTime;

        public delegate void MeasureSequenceVoiceCountHandler(Sound sound, int measureTime);

        /// <summary>
        ///
        /// </summary>
        public static MeasureSequenceVoiceCountHandler SequenceVoiceCountMeasurer
        {
            get;
            set;
        }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="queryParameter">パラメータの問い合わせ先。</param>
        public QueryAndMeasureSequenceVoiceCountHandler(IQueryCommandParameter queryParameter)
            : base(queryParameter)
        {
        }

        /// <summary>
        /// コマンドハンドラが実行可能なコマンドIDを取得します。
        /// </summary>
        public override string TargetCommandID
        {
            get { return PreviewCommands.MeasureSequenceVoiceCount.ID; }
        }

        /// <summary>
        /// ExecuteInternal() の開始時に実行します。
        /// </summary>
        protected override bool PreExecAction()
        {
            MeasureDialog dialog = new MeasureDialog();
            dialog.Text = MessageResource.Title_MeasureSequenceVoiceCount;
            if (dialog.ShowDialog() != DialogResult.OK)
            {
                return false;
            }

            this.measureTime = dialog.MeasureTime;

            return true;
        }

        /// <summary>
        /// ExecuteInternal() のループ処理内に実行します。
        /// </summary>
        protected override void ExecAction(Sound sound)
        {
            Debug.Assert(SequenceVoiceCountMeasurer != null);
            SequenceVoiceCountMeasurer(sound, this.measureTime);
        }
    }
}
