﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.CommandHandlers
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;

    using NintendoWare.SoundFoundation.CommandHandlers;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Operations;
    using NintendoWare.SoundFoundation.Parameters;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Framework.Commands;
    using NintendoWare.SoundMaker.Framework.Windows;

    ///--------------------------------------------------------------------------
    /// <summary>
    /// "アイテムを有効/無効にする"ハンドラ
    /// </summary>
    public class EnableItemHandler : EditCommandHandler
    {
        ///--------------------------------
        /// <summary>
        /// </summary>
        public EnableItemHandler(IQueryCommandParameter queryParameter, bool value)
            : base(value != false ? EditCommands.EnableItem.ID : EditCommands.DisableItem.ID, queryParameter)
        {
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override CommandStatus QueryStatusInternal(Command command, IQueryCommandParameter parameters)
        {
            Component[] components = GetTargetComponents(parameters);

            if (null == GetTargetDocument(parameters)) { return CommandStatus.SupportedAndVisible; }
            if (null == components) { return CommandStatus.SupportedAndVisible; }

            return components.Length > 0 ? CommandStatus.SupportedAndEnabledAndVisible :
                CommandStatus.SupportedAndVisible;
        }

        ///--------------------------------
        /// <summary>
        /// </summary>
        protected override bool ExecuteInternal(Command command, IQueryCommandParameter parameters)
        {
            Component[] components = GetTargetComponents(parameters);

            if (components == null)
            {
                return false;
            }

            OperationHistory operationHistory = GetTargetDocument(parameters).OperationHistory;
            Operation operation = null;
            bool value = TargetCommandID == EditCommands.EnableItem.ID ? true : false;

            operationHistory.BeginTransaction();

            foreach (Component component in components)
            {
                operation = new SetParameterOperation
                    (component.Parameters, ProjectParameterNames.IsEnabled, value);
                operation.Execute();
                operationHistory.AddOperation(operation);
            }

            operationHistory.EndTransaction();
            return true;
        }
    }
}
