﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Windows.Forms
{
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Framework.FileFormats;
    using NintendoWare.SoundMaker.Framework.Windows.Forms;

    public class CommonListAdapterCommon : CommonListAdapter
    {
        public CommonListAdapterCommon(CommonListDecorationEvaluator decorationEvaluator)
            : base(decorationEvaluator)
        {
        }

        public override void SetValue(Component targetComponent, string name, object value)
        {
            if (name == ProjectParameterNames.WaveEncoding &&
                targetComponent is StreamSoundBase == true &&
                targetComponent.Children.Count == 1)
            {
                StreamSoundTrackBase track = targetComponent.Children[0] as StreamSoundTrackBase;
                if (AACUtil.IsAACFile(track.FilePath) == true || FileUtil.IsOpusFile(track.FilePath) == true)
                {
                    return;
                }
            }

            base.SetValue(targetComponent, name, value);
        }
    }
}
