﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// MEFを使うには以下の2つが必要です。
// 参照設定にもSystem.ComponentModel.Compositionを追加する必要があります。
using System.ComponentModel.Composition;
using System.ComponentModel.Composition.Hosting;

namespace NintendoWare.SoundMakerPlugin
{
    public class SoundMakerPluginManager
    {
        private static SoundMakerPluginManager soundMakerPluginManager;
        private CompositionContainer compositionContainer = null;

        public event EventHandler PlatformChanged;

        public SoundMakerPluginManager(string path)
        {
            var catalog = new DirectoryCatalog(path, "SoundMakerPlugin*.dll");
            this.compositionContainer = new CompositionContainer(catalog);
            this.compositionContainer.ComposeParts(this);

            this.SetCurrentPlatform("Generic");
            soundMakerPluginManager = this;
        }

        public static SoundMakerPluginManager Instance
        {
            get
            {
                return soundMakerPluginManager;
            }
        }

        [ImportMany]
        public IEnumerable<ISoundMakerPlugin> Instances
        {
            get;
            set;
        }

        public ISoundMakerPlugin CurrentSoundMakerPlugin
        {
            get;
            private set;
        }

        public void SetCurrentPlatform(string platform)
        {
            foreach (ISoundMakerPlugin plugin in this.Instances)
            {
                if (plugin.Platform == platform)
                {
                    this.CurrentSoundMakerPlugin = plugin;
                    this.OnPlatformChanged();
                    return;
                }
            }
        }

        private void OnPlatformChanged()
        {
            if (null != this.PlatformChanged)
            {
                this.PlatformChanged(this, new EventArgs());
            }
        }
    }
}
