﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Preview.HIO
{
    /// <summary>
    /// メッセージのカテゴリを示します。
    /// </summary>
    public enum MessageCategory : uint
    {
        /// <summary>
        /// システムカテゴリ
        /// </summary>
        System = MessageUtilitiy.CategoryBegin,

        /// <summary>
        /// 3Dグラフィックスカテゴリ
        /// </summary>
        Graphics3D,

        /// <summary>
        /// サウンドカテゴリ
        /// </summary>
        Sound,
    }

    /// <summary>
    /// メッセージの種類を示します。
    /// </summary>
    public enum Message : uint
    {
        //-----------------------------------------------------------------
        // システムメッセージ
        //-----------------------------------------------------------------

        /// <summary>
        /// 無効なメッセージです。
        /// </summary>
        Invalid = 0x00 + MessageCategory.System,

        //-----------------------------------------------------------------
        // サウンドメッセージ
        //-----------------------------------------------------------------

        /// <summary>
        /// サウンドの状態をリセットします。
        /// </summary>
        SoundReset = 0x00 + MessageCategory.Sound,
    }

    /// <summary>
    /// メッセージユーティリティクラスです。
    /// </summary>
    internal static class MessageUtilitiy
    {
        internal const Message CategoryMask = (Message)0xFFFF0000;
        internal const Message MessageMask = (Message)0x0000FFFF;

        internal const uint CategoryBegin = 0x00010000;
        internal const uint CategoryEnd = 0x7FFF0000;
    }
}
