﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Preview.HIO
{
    /// <summary>
    /// エラーコードのカテゴリを示します。
    /// </summary>
    public enum ErrorCodeCategory : uint
    {
        /// <summary>
        /// システムカテゴリ
        /// </summary>
        System = ErrorCodeUtilitiy.CategoryBegin,

        /// <summary>
        /// 3Dグラフィックスカテゴリ
        /// </summary>
        Graphics3D,

        /// <summary>
        /// サウンドカテゴリ
        /// </summary>
        Sound,
    }

    /// <summary>
    /// エラーコードを示します。
    /// </summary>
    public enum ErrorCode : uint
    {
        //-----------------------------------------------------------------
        // エラーコードの種類
        //-----------------------------------------------------------------

        /// <summary>
        /// 成功コード
        /// </summary>
        Succeeded = 0x00000000,

        /// <summary>
        /// エラーコード
        /// </summary>
        Failed = 0x80000000,

        //-----------------------------------------------------------------
        // システムエラー
        //-----------------------------------------------------------------

        //-----------------------------------------------------------------
        // サウンドエラー
        //-----------------------------------------------------------------
    }

    /// <summary>
    /// エラーコードユーティリティクラスです。
    /// </summary>
    internal static class ErrorCodeUtilitiy
    {
        internal const uint TypeMask = 0x80000000;
        internal const uint CategoryMask = 0x7FFF0000;
        internal const uint CodeMask = 0x0000FFFF;

        internal const uint CategoryBegin = 0x00010000;
        internal const uint CategoryEnd = 0x7FFF0000;
    }
}
