﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Preview.Configurations
{
    using System;
    using NintendoWare.SoundMaker.Configurations.Schemas;
    using NW4R.ProtocolSound;

    public class ReverbStdConverter : EffectConverter<XmlReverbStd, ReverbStdParameter>
    {
        protected override void ApplyParameters(XmlReverbStd xmlEffect, ReverbStdParameter effectParameter)
        {
            effectParameter.EarlyMode = xmlEffect.EarlyMode;
            effectParameter.PreDelayTimeMax = xmlEffect.PreDelayTimeMax;
            effectParameter.PreDelayTime = xmlEffect.PreDelayTime;
            effectParameter.FusedMode = ConvertFusedMode(xmlEffect.FusedMode);
            effectParameter.FusedTime = xmlEffect.FusedTime;
            effectParameter.Coloration = xmlEffect.Coloration;
            effectParameter.Damping = xmlEffect.Damping;
            effectParameter.EarlyGain = xmlEffect.EarlyGain;
            effectParameter.FusedGain = xmlEffect.FusedGain;
            effectParameter.OutGain = xmlEffect.OutGain;
        }

        protected override void ExtractParameters(ReverbStdParameter effectParameter, XmlReverbStd xmlEffect)
        {
            xmlEffect.EarlyMode = effectParameter.EarlyMode;
            xmlEffect.PreDelayTimeMax = effectParameter.PreDelayTimeMax;
            xmlEffect.PreDelayTime = effectParameter.PreDelayTime;
            xmlEffect.FusedMode = ConvertFusedMode(effectParameter.FusedMode);
            xmlEffect.FusedTime = effectParameter.FusedTime;
            xmlEffect.Coloration = effectParameter.Coloration;
            xmlEffect.Damping = effectParameter.Damping;
            xmlEffect.EarlyGain = effectParameter.EarlyGain;
            xmlEffect.FusedGain = effectParameter.FusedGain;
            xmlEffect.OutGain = effectParameter.OutGain;
        }

        private ToolSoundFusedMode ConvertFusedMode(XmlReverbStdFusedMode fusedMode)
        {
            switch (fusedMode)
            {
                case XmlReverbStdFusedMode.OldAxfx:
                    return ToolSoundFusedMode.FusedMode_OldAxfx;

                case XmlReverbStdFusedMode.MetalTank:
                    return ToolSoundFusedMode.FusedMode_MetalTank;

                case XmlReverbStdFusedMode.SmallRoom:
                    return ToolSoundFusedMode.FusedMode_SmallRoom;

                case XmlReverbStdFusedMode.LargeRoom:
                    return ToolSoundFusedMode.FusedMode_LargeRoom;

                case XmlReverbStdFusedMode.Hall:
                    return ToolSoundFusedMode.FusedMode_Hall;

                case XmlReverbStdFusedMode.Cavernous:
                    return ToolSoundFusedMode.FusedMode_Cavernous;
            }

            throw new ApplicationException("invalid effect bus type.");
        }

        private XmlReverbStdFusedMode ConvertFusedMode(ToolSoundFusedMode fusedMode)
        {
            switch (fusedMode)
            {
                case ToolSoundFusedMode.FusedMode_OldAxfx:
                    return XmlReverbStdFusedMode.OldAxfx;

                case ToolSoundFusedMode.FusedMode_MetalTank:
                    return XmlReverbStdFusedMode.MetalTank;

                case ToolSoundFusedMode.FusedMode_SmallRoom:
                    return XmlReverbStdFusedMode.SmallRoom;

                case ToolSoundFusedMode.FusedMode_LargeRoom:
                    return XmlReverbStdFusedMode.LargeRoom;

                case ToolSoundFusedMode.FusedMode_Hall:
                    return XmlReverbStdFusedMode.Hall;

                case ToolSoundFusedMode.FusedMode_Cavernous:
                    return XmlReverbStdFusedMode.Cavernous;
            }

            throw new ApplicationException("invalid effect bus type.");
        }
    }
}
