﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Preview.Communications.Viewer
{
    using System;
    using System.Diagnostics;
    using NintendoWare.SoundMaker.Preview.MCS.Viewer;

    /// <summary>
    /// サウンド用Viewerパケットファクトリー
    /// </summary>
    public class SoundPacketFactoryCommon : SoundPacketFactory
    {
        protected override ViewerPacket InternalCreatePacket(CommPacketHeader header)
        {
            switch (header.PacketType)
            {
                case Constants.TOOL_SOUND_GET_SOUNDINFORMATIONS:
                    return new GetSoundInformationPacket();

                case Constants.TOOL_SOUND_SET_PREVIEWPLAYERPARAMETER:
                    return new SetPreviewPlayerParameterPacket();

                case Constants.TOOL_SOUND_SET_EFFECTPARAMETERS:
                    return new SetEffectParametersPacket();

                case Constants.TOOL_SOUND_GET_SEQVARIABLES:
                    return new GetSeqVariablesPacket();
            }

            return null;
        }
    }
}
