﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Configurations
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.Diagnostics;
    using System.Linq;
    using NintendoWare.SoundMaker.Configurations;
    using NintendoWare.SoundMaker.Framework.Configurations;
    using NintendoWare.SoundMaker.Resources;
    using SoundFoundation.Core.Collections;
    using SoundFoundation.Projects;

    /// <summary>
    /// 全てのリストの特性を管理します。
    /// </summary>
    public class ListTraitsCommon : ListTraits
    {
        #region ** 固定値

        public const string ColumnName_RemoteFilter = ProjectParameterNamesCommon.RemoteFilter;
        public const string ColumnName_AuxCSend = ProjectParameterNamesCommon.Sends.AuxCSend;
        public const string ColumnName_TrackAuxCSend = ProjectParameterNamesCommon.StreamSoundTrack.Sends.AuxCSend;

        #endregion

        /// <summary>
        ///
        /// </summary>
        public ListTraitsCommon()
        {
        }

        /// <summary>
        ///
        /// </summary>
        protected override void InitializeLists()
        {
            AddList(ListName_StreamSound,
                     new string[] {
                         ColumnName_SndEdit,
                         ColumnName_PreviewPlay,
                         ColumnName_Name,
                         ColumnName_SinglePlayType,
                         ColumnName_SinglePlayEffectiveDuration,
                         ColumnName_WaveEncoding,
                         ColumnName_FilePath,
                         ColumnName_WaveTime,
                         ColumnName_IsPrefetchEnabled,
                         ColumnName_IsResampleEnabled,
                         ColumnName_SampleRate,
                         ColumnName_WaveBitRate,
                         ColumnName_WaveSampleBit,
                         ColumnName_IsDownMixEnabled,
                         ColumnName_WaveChannel,
                         ColumnName_Volume,
                         ColumnName_IntegratedLoudness,
                         ColumnName_PlayerPriority,
                         ColumnName_PlayerReference,
                         ColumnName_ActorPlayer,
                         ColumnName_RemoteFilter,
                         ColumnName_Enable3DVolume,
                         ColumnName_Enable3DPan,
                         ColumnName_Enable3DSurroundPan,
                         ColumnName_Enable3DPriority,
                         ColumnName_Enable3DFilter,
                         ColumnName_DecayCurve3D,
                         ColumnName_DecayRatio3D,
                         ColumnName_DopplerFactor3D,
                         ColumnName_PanMode,
                         ColumnName_PanCurve,
                         ColumnName_FrontBypass,
                         ColumnName_Pitch,

                         ColumnName_AuxASend,
                         ColumnName_AuxBSend,
                         ColumnName_AuxCSend,
                         ColumnName_MainSend,

                         ColumnName_UserParameter0,
                         ColumnName_UserParameter1,
                         ColumnName_UserParameter2,
                         ColumnName_UserParameter3,

                         ColumnName_UserParameters[0,0],
                         ColumnName_UserParameters[0,1],
                         ColumnName_UserParameters[0,2],
                         ColumnName_UserParameters[0,3],
                         ColumnName_UserParameters[0,4],
                         ColumnName_UserParameters[0,5],
                         ColumnName_UserParameters[0,6],
                         ColumnName_UserParameters[0,7],
                         ColumnName_UserParameters[0,8],
                         ColumnName_UserParameters[0,9],
                         ColumnName_UserParameters[0,10],
                         ColumnName_UserParameters[0,11],
                         ColumnName_UserParameters[0,12],
                         ColumnName_UserParameters[0,13],
                         ColumnName_UserParameters[0,14],
                         ColumnName_UserParameters[0,15],
                         ColumnName_UserParameters[0,16],
                         ColumnName_UserParameters[0,17],
                         ColumnName_UserParameters[0,18],
                         ColumnName_UserParameters[0,19],
                         ColumnName_UserParameters[0,20],
                         ColumnName_UserParameters[0,21],
                         ColumnName_UserParameters[0,22],
                         ColumnName_UserParameters[0,23],
                         ColumnName_UserParameters[0,24],
                         ColumnName_UserParameters[0,25],
                         ColumnName_UserParameters[0,26],
                         ColumnName_UserParameters[0,27],
                         ColumnName_UserParameters[0,28],
                         ColumnName_UserParameters[0,29],
                         ColumnName_UserParameters[0,30],
                         ColumnName_UserParameters[0,31],
                         ColumnName_UserParameters[1,0],
                         ColumnName_UserParameters[1,1],
                         ColumnName_UserParameters[1,2],
                         ColumnName_UserParameters[1,3],
                         ColumnName_UserParameters[1,4],
                         ColumnName_UserParameters[1,5],
                         ColumnName_UserParameters[1,6],
                         ColumnName_UserParameters[1,7],
                         ColumnName_UserParameters[1,8],
                         ColumnName_UserParameters[1,9],
                         ColumnName_UserParameters[1,10],
                         ColumnName_UserParameters[1,11],
                         ColumnName_UserParameters[1,12],
                         ColumnName_UserParameters[1,13],
                         ColumnName_UserParameters[1,14],
                         ColumnName_UserParameters[1,15],
                         ColumnName_UserParameters[1,16],
                         ColumnName_UserParameters[1,17],
                         ColumnName_UserParameters[1,18],
                         ColumnName_UserParameters[1,19],
                         ColumnName_UserParameters[1,20],
                         ColumnName_UserParameters[1,21],
                         ColumnName_UserParameters[1,22],
                         ColumnName_UserParameters[1,23],
                         ColumnName_UserParameters[1,24],
                         ColumnName_UserParameters[1,25],
                         ColumnName_UserParameters[1,26],
                         ColumnName_UserParameters[1,27],
                         ColumnName_UserParameters[1,28],
                         ColumnName_UserParameters[1,29],
                         ColumnName_UserParameters[1,30],
                         ColumnName_UserParameters[1,31],
                         ColumnName_UserParameters[2,0],
                         ColumnName_UserParameters[2,1],
                         ColumnName_UserParameters[2,2],
                         ColumnName_UserParameters[2,3],
                         ColumnName_UserParameters[2,4],
                         ColumnName_UserParameters[2,5],
                         ColumnName_UserParameters[2,6],
                         ColumnName_UserParameters[2,7],
                         ColumnName_UserParameters[2,8],
                         ColumnName_UserParameters[2,9],
                         ColumnName_UserParameters[2,10],
                         ColumnName_UserParameters[2,11],
                         ColumnName_UserParameters[2,12],
                         ColumnName_UserParameters[2,13],
                         ColumnName_UserParameters[2,14],
                         ColumnName_UserParameters[2,15],
                         ColumnName_UserParameters[2,16],
                         ColumnName_UserParameters[2,17],
                         ColumnName_UserParameters[2,18],
                         ColumnName_UserParameters[2,19],
                         ColumnName_UserParameters[2,20],
                         ColumnName_UserParameters[2,21],
                         ColumnName_UserParameters[2,22],
                         ColumnName_UserParameters[2,23],
                         ColumnName_UserParameters[2,24],
                         ColumnName_UserParameters[2,25],
                         ColumnName_UserParameters[2,26],
                         ColumnName_UserParameters[2,27],
                         ColumnName_UserParameters[2,28],
                         ColumnName_UserParameters[2,29],
                         ColumnName_UserParameters[2,30],
                         ColumnName_UserParameters[2,31],
                         ColumnName_UserParameters[3,0],
                         ColumnName_UserParameters[3,1],
                         ColumnName_UserParameters[3,2],
                         ColumnName_UserParameters[3,3],
                         ColumnName_UserParameters[3,4],
                         ColumnName_UserParameters[3,5],
                         ColumnName_UserParameters[3,6],
                         ColumnName_UserParameters[3,7],
                         ColumnName_UserParameters[3,8],
                         ColumnName_UserParameters[3,9],
                         ColumnName_UserParameters[3,10],
                         ColumnName_UserParameters[3,11],
                         ColumnName_UserParameters[3,12],
                         ColumnName_UserParameters[3,13],
                         ColumnName_UserParameters[3,14],
                         ColumnName_UserParameters[3,15],
                         ColumnName_UserParameters[3,16],
                         ColumnName_UserParameters[3,17],
                         ColumnName_UserParameters[3,18],
                         ColumnName_UserParameters[3,19],
                         ColumnName_UserParameters[3,20],
                         ColumnName_UserParameters[3,21],
                         ColumnName_UserParameters[3,22],
                         ColumnName_UserParameters[3,23],
                         ColumnName_UserParameters[3,24],
                         ColumnName_UserParameters[3,25],
                         ColumnName_UserParameters[3,26],
                         ColumnName_UserParameters[3,27],
                         ColumnName_UserParameters[3,28],
                         ColumnName_UserParameters[3,29],
                         ColumnName_UserParameters[3,30],
                         ColumnName_UserParameters[3,31],

                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                     });

            AddList(ListName_StreamSoundTrack,
                     new string[] {
                         ColumnName_TrackNo,
                         ColumnName_FilePath,
                         ColumnName_WaveTime,
                         ColumnName_SampleRate,
                         ColumnName_WaveBitRate,
                         ColumnName_WaveSampleBit,
                         ColumnName_WaveChannel,
                         ColumnName_Volume,
                         ColumnName_Pan,
                         ColumnName_SurroundPan,
                         ColumnName_FrontBypass,
                         ColumnName_LPF,
                         ColumnName_BiquadType,
                         ColumnName_Biquad,

                         ColumnName_AuxASend,
                         ColumnName_AuxBSend,
                         ColumnName_AuxCSend,
                         ColumnName_MainSend,

                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                     });

            AddList(ListName_WaveSoundSet,
                    new string[] {
                         ColumnName_Name,
                         ColumnName_WaveArchiveReference,
                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_WaveSoundSetItem,
                    new string[] {
                         ColumnName_SndEdit,
                         ColumnName_PreviewPlay,
                         ColumnName_Name,
                         ColumnName_SinglePlayType,
                         ColumnName_SinglePlayEffectiveDuration,
                         ColumnName_WaveEncoding,
                         ColumnName_FilePath,
                         ColumnName_WaveTime,
                         ColumnName_IsResampleEnabled,
                         ColumnName_SampleRate,
                         ColumnName_WaveBitRate,
                         ColumnName_WaveSampleBit,
                         ColumnName_IsDownMixEnabled,
                         ColumnName_WaveChannel,
                         ColumnName_DataSize,
                         ColumnName_Volume,
                         ColumnName_IntegratedLoudness,
                         ColumnName_ChannelPriority,
                         ColumnName_PlayerPriority,
                         ColumnName_PlayerReference,
                         ColumnName_ActorPlayer,
                         ColumnName_Pan,
                         ColumnName_SurroundPan,
                         ColumnName_Pitch,
                         ColumnName_LPF,
                         ColumnName_BiquadType,
                         ColumnName_Biquad,
                         ColumnName_WaveSoundEnvelopeRelease,

                         ColumnName_AuxASend,
                         ColumnName_AuxBSend,
                         ColumnName_AuxCSend,
                         ColumnName_MainSend,

                         ColumnName_RemoteFilter,
                         ColumnName_ReleasePriorityFixed,
                         ColumnName_Enable3DVolume,
                         ColumnName_Enable3DPan,
                         ColumnName_Enable3DSurroundPan,
                         ColumnName_Enable3DPriority,
                         ColumnName_Enable3DFilter,
                         ColumnName_DecayCurve3D,
                         ColumnName_DecayRatio3D,
                         ColumnName_DopplerFactor3D,
                         ColumnName_PanMode,
                         ColumnName_PanCurve,
                         ColumnName_FrontBypass,

                         ColumnName_UserParameter0,
                         ColumnName_UserParameter1,
                         ColumnName_UserParameter2,
                         ColumnName_UserParameter3,

                         ColumnName_UserParameters[0,0],
                         ColumnName_UserParameters[0,1],
                         ColumnName_UserParameters[0,2],
                         ColumnName_UserParameters[0,3],
                         ColumnName_UserParameters[0,4],
                         ColumnName_UserParameters[0,5],
                         ColumnName_UserParameters[0,6],
                         ColumnName_UserParameters[0,7],
                         ColumnName_UserParameters[0,8],
                         ColumnName_UserParameters[0,9],
                         ColumnName_UserParameters[0,10],
                         ColumnName_UserParameters[0,11],
                         ColumnName_UserParameters[0,12],
                         ColumnName_UserParameters[0,13],
                         ColumnName_UserParameters[0,14],
                         ColumnName_UserParameters[0,15],
                         ColumnName_UserParameters[0,16],
                         ColumnName_UserParameters[0,17],
                         ColumnName_UserParameters[0,18],
                         ColumnName_UserParameters[0,19],
                         ColumnName_UserParameters[0,20],
                         ColumnName_UserParameters[0,21],
                         ColumnName_UserParameters[0,22],
                         ColumnName_UserParameters[0,23],
                         ColumnName_UserParameters[0,24],
                         ColumnName_UserParameters[0,25],
                         ColumnName_UserParameters[0,26],
                         ColumnName_UserParameters[0,27],
                         ColumnName_UserParameters[0,28],
                         ColumnName_UserParameters[0,29],
                         ColumnName_UserParameters[0,30],
                         ColumnName_UserParameters[0,31],
                         ColumnName_UserParameters[1,0],
                         ColumnName_UserParameters[1,1],
                         ColumnName_UserParameters[1,2],
                         ColumnName_UserParameters[1,3],
                         ColumnName_UserParameters[1,4],
                         ColumnName_UserParameters[1,5],
                         ColumnName_UserParameters[1,6],
                         ColumnName_UserParameters[1,7],
                         ColumnName_UserParameters[1,8],
                         ColumnName_UserParameters[1,9],
                         ColumnName_UserParameters[1,10],
                         ColumnName_UserParameters[1,11],
                         ColumnName_UserParameters[1,12],
                         ColumnName_UserParameters[1,13],
                         ColumnName_UserParameters[1,14],
                         ColumnName_UserParameters[1,15],
                         ColumnName_UserParameters[1,16],
                         ColumnName_UserParameters[1,17],
                         ColumnName_UserParameters[1,18],
                         ColumnName_UserParameters[1,19],
                         ColumnName_UserParameters[1,20],
                         ColumnName_UserParameters[1,21],
                         ColumnName_UserParameters[1,22],
                         ColumnName_UserParameters[1,23],
                         ColumnName_UserParameters[1,24],
                         ColumnName_UserParameters[1,25],
                         ColumnName_UserParameters[1,26],
                         ColumnName_UserParameters[1,27],
                         ColumnName_UserParameters[1,28],
                         ColumnName_UserParameters[1,29],
                         ColumnName_UserParameters[1,30],
                         ColumnName_UserParameters[1,31],
                         ColumnName_UserParameters[2,0],
                         ColumnName_UserParameters[2,1],
                         ColumnName_UserParameters[2,2],
                         ColumnName_UserParameters[2,3],
                         ColumnName_UserParameters[2,4],
                         ColumnName_UserParameters[2,5],
                         ColumnName_UserParameters[2,6],
                         ColumnName_UserParameters[2,7],
                         ColumnName_UserParameters[2,8],
                         ColumnName_UserParameters[2,9],
                         ColumnName_UserParameters[2,10],
                         ColumnName_UserParameters[2,11],
                         ColumnName_UserParameters[2,12],
                         ColumnName_UserParameters[2,13],
                         ColumnName_UserParameters[2,14],
                         ColumnName_UserParameters[2,15],
                         ColumnName_UserParameters[2,16],
                         ColumnName_UserParameters[2,17],
                         ColumnName_UserParameters[2,18],
                         ColumnName_UserParameters[2,19],
                         ColumnName_UserParameters[2,20],
                         ColumnName_UserParameters[2,21],
                         ColumnName_UserParameters[2,22],
                         ColumnName_UserParameters[2,23],
                         ColumnName_UserParameters[2,24],
                         ColumnName_UserParameters[2,25],
                         ColumnName_UserParameters[2,26],
                         ColumnName_UserParameters[2,27],
                         ColumnName_UserParameters[2,28],
                         ColumnName_UserParameters[2,29],
                         ColumnName_UserParameters[2,30],
                         ColumnName_UserParameters[2,31],
                         ColumnName_UserParameters[3,0],
                         ColumnName_UserParameters[3,1],
                         ColumnName_UserParameters[3,2],
                         ColumnName_UserParameters[3,3],
                         ColumnName_UserParameters[3,4],
                         ColumnName_UserParameters[3,5],
                         ColumnName_UserParameters[3,6],
                         ColumnName_UserParameters[3,7],
                         ColumnName_UserParameters[3,8],
                         ColumnName_UserParameters[3,9],
                         ColumnName_UserParameters[3,10],
                         ColumnName_UserParameters[3,11],
                         ColumnName_UserParameters[3,12],
                         ColumnName_UserParameters[3,13],
                         ColumnName_UserParameters[3,14],
                         ColumnName_UserParameters[3,15],
                         ColumnName_UserParameters[3,16],
                         ColumnName_UserParameters[3,17],
                         ColumnName_UserParameters[3,18],
                         ColumnName_UserParameters[3,19],
                         ColumnName_UserParameters[3,20],
                         ColumnName_UserParameters[3,21],
                         ColumnName_UserParameters[3,22],
                         ColumnName_UserParameters[3,23],
                         ColumnName_UserParameters[3,24],
                         ColumnName_UserParameters[3,25],
                         ColumnName_UserParameters[3,26],
                         ColumnName_UserParameters[3,27],
                         ColumnName_UserParameters[3,28],
                         ColumnName_UserParameters[3,29],
                         ColumnName_UserParameters[3,30],
                         ColumnName_UserParameters[3,31],

                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                   });

            AddList(ListName_SequenceSoundSet,
                    new string[] {
                         ColumnName_Name,
                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_SequenceSoundSetItem,
                    new string[] {
                         ColumnName_SndEdit,
                         ColumnName_PreviewPlay,
                         ColumnName_Name,
                         ColumnName_SinglePlayType,
                         ColumnName_SinglePlayEffectiveDuration,
                         ColumnName_FileType,
                         ColumnName_FilePath,
                         ColumnName_StartPosition,
                         ColumnName_SoundSetBankReferences,
                         ColumnName_PlayerReference,
                         ColumnName_Volume,
                         ColumnName_IntegratedLoudness,
                         ColumnName_ChannelPriority,
                         ColumnName_PlayerPriority,
                         ColumnName_ActorPlayer,
                         ColumnName_RemoteFilter,
                         ColumnName_ReleasePriorityFixed,
                         ColumnName_Enable3DVolume,
                         ColumnName_Enable3DPan,
                         ColumnName_Enable3DSurroundPan,
                         ColumnName_Enable3DPriority,
                         ColumnName_Enable3DFilter,
                         ColumnName_DecayCurve3D,
                         ColumnName_DecayRatio3D,
                         ColumnName_DopplerFactor3D,
                         ColumnName_FrontBypass,
                         ColumnName_MaximumVoiceCount,

                         ColumnName_UserParameter0,
                         ColumnName_UserParameter1,
                         ColumnName_UserParameter2,
                         ColumnName_UserParameter3,

                         ColumnName_UserParameters[0,0],
                         ColumnName_UserParameters[0,1],
                         ColumnName_UserParameters[0,2],
                         ColumnName_UserParameters[0,3],
                         ColumnName_UserParameters[0,4],
                         ColumnName_UserParameters[0,5],
                         ColumnName_UserParameters[0,6],
                         ColumnName_UserParameters[0,7],
                         ColumnName_UserParameters[0,8],
                         ColumnName_UserParameters[0,9],
                         ColumnName_UserParameters[0,10],
                         ColumnName_UserParameters[0,11],
                         ColumnName_UserParameters[0,12],
                         ColumnName_UserParameters[0,13],
                         ColumnName_UserParameters[0,14],
                         ColumnName_UserParameters[0,15],
                         ColumnName_UserParameters[0,16],
                         ColumnName_UserParameters[0,17],
                         ColumnName_UserParameters[0,18],
                         ColumnName_UserParameters[0,19],
                         ColumnName_UserParameters[0,20],
                         ColumnName_UserParameters[0,21],
                         ColumnName_UserParameters[0,22],
                         ColumnName_UserParameters[0,23],
                         ColumnName_UserParameters[0,24],
                         ColumnName_UserParameters[0,25],
                         ColumnName_UserParameters[0,26],
                         ColumnName_UserParameters[0,27],
                         ColumnName_UserParameters[0,28],
                         ColumnName_UserParameters[0,29],
                         ColumnName_UserParameters[0,30],
                         ColumnName_UserParameters[0,31],
                         ColumnName_UserParameters[1,0],
                         ColumnName_UserParameters[1,1],
                         ColumnName_UserParameters[1,2],
                         ColumnName_UserParameters[1,3],
                         ColumnName_UserParameters[1,4],
                         ColumnName_UserParameters[1,5],
                         ColumnName_UserParameters[1,6],
                         ColumnName_UserParameters[1,7],
                         ColumnName_UserParameters[1,8],
                         ColumnName_UserParameters[1,9],
                         ColumnName_UserParameters[1,10],
                         ColumnName_UserParameters[1,11],
                         ColumnName_UserParameters[1,12],
                         ColumnName_UserParameters[1,13],
                         ColumnName_UserParameters[1,14],
                         ColumnName_UserParameters[1,15],
                         ColumnName_UserParameters[1,16],
                         ColumnName_UserParameters[1,17],
                         ColumnName_UserParameters[1,18],
                         ColumnName_UserParameters[1,19],
                         ColumnName_UserParameters[1,20],
                         ColumnName_UserParameters[1,21],
                         ColumnName_UserParameters[1,22],
                         ColumnName_UserParameters[1,23],
                         ColumnName_UserParameters[1,24],
                         ColumnName_UserParameters[1,25],
                         ColumnName_UserParameters[1,26],
                         ColumnName_UserParameters[1,27],
                         ColumnName_UserParameters[1,28],
                         ColumnName_UserParameters[1,29],
                         ColumnName_UserParameters[1,30],
                         ColumnName_UserParameters[1,31],
                         ColumnName_UserParameters[2,0],
                         ColumnName_UserParameters[2,1],
                         ColumnName_UserParameters[2,2],
                         ColumnName_UserParameters[2,3],
                         ColumnName_UserParameters[2,4],
                         ColumnName_UserParameters[2,5],
                         ColumnName_UserParameters[2,6],
                         ColumnName_UserParameters[2,7],
                         ColumnName_UserParameters[2,8],
                         ColumnName_UserParameters[2,9],
                         ColumnName_UserParameters[2,10],
                         ColumnName_UserParameters[2,11],
                         ColumnName_UserParameters[2,12],
                         ColumnName_UserParameters[2,13],
                         ColumnName_UserParameters[2,14],
                         ColumnName_UserParameters[2,15],
                         ColumnName_UserParameters[2,16],
                         ColumnName_UserParameters[2,17],
                         ColumnName_UserParameters[2,18],
                         ColumnName_UserParameters[2,19],
                         ColumnName_UserParameters[2,20],
                         ColumnName_UserParameters[2,21],
                         ColumnName_UserParameters[2,22],
                         ColumnName_UserParameters[2,23],
                         ColumnName_UserParameters[2,24],
                         ColumnName_UserParameters[2,25],
                         ColumnName_UserParameters[2,26],
                         ColumnName_UserParameters[2,27],
                         ColumnName_UserParameters[2,28],
                         ColumnName_UserParameters[2,29],
                         ColumnName_UserParameters[2,30],
                         ColumnName_UserParameters[2,31],
                         ColumnName_UserParameters[3,0],
                         ColumnName_UserParameters[3,1],
                         ColumnName_UserParameters[3,2],
                         ColumnName_UserParameters[3,3],
                         ColumnName_UserParameters[3,4],
                         ColumnName_UserParameters[3,5],
                         ColumnName_UserParameters[3,6],
                         ColumnName_UserParameters[3,7],
                         ColumnName_UserParameters[3,8],
                         ColumnName_UserParameters[3,9],
                         ColumnName_UserParameters[3,10],
                         ColumnName_UserParameters[3,11],
                         ColumnName_UserParameters[3,12],
                         ColumnName_UserParameters[3,13],
                         ColumnName_UserParameters[3,14],
                         ColumnName_UserParameters[3,15],
                         ColumnName_UserParameters[3,16],
                         ColumnName_UserParameters[3,17],
                         ColumnName_UserParameters[3,18],
                         ColumnName_UserParameters[3,19],
                         ColumnName_UserParameters[3,20],
                         ColumnName_UserParameters[3,21],
                         ColumnName_UserParameters[3,22],
                         ColumnName_UserParameters[3,23],
                         ColumnName_UserParameters[3,24],
                         ColumnName_UserParameters[3,25],
                         ColumnName_UserParameters[3,26],
                         ColumnName_UserParameters[3,27],
                         ColumnName_UserParameters[3,28],
                         ColumnName_UserParameters[3,29],
                         ColumnName_UserParameters[3,30],
                         ColumnName_UserParameters[3,31],

                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_SequenceSound,
                    new string[] {
                         ColumnName_SndEdit,
                         ColumnName_PreviewPlay,
                         ColumnName_Name,
                         ColumnName_SinglePlayType,
                         ColumnName_SinglePlayEffectiveDuration,
                         ColumnName_FileType,
                         ColumnName_FilePath,
                         ColumnName_StartPosition,
                         ColumnName_SoundSetBankReferences,
                         ColumnName_PlayerReference,
                         ColumnName_Volume,
                         ColumnName_IntegratedLoudness,
                         ColumnName_ChannelPriority,
                         ColumnName_PlayerPriority,
                         ColumnName_ActorPlayer,
                         ColumnName_RemoteFilter,
                         ColumnName_ReleasePriorityFixed,
                         ColumnName_Enable3DVolume,
                         ColumnName_Enable3DPan,
                         ColumnName_Enable3DSurroundPan,
                         ColumnName_Enable3DPriority,
                         ColumnName_Enable3DFilter,
                         ColumnName_DecayCurve3D,
                         ColumnName_DecayRatio3D,
                         ColumnName_DopplerFactor3D,
                         ColumnName_FrontBypass,

                         ColumnName_UserParameter0,
                         ColumnName_UserParameter1,
                         ColumnName_UserParameter2,
                         ColumnName_UserParameter3,

                         ColumnName_UserParameters[0,0],
                         ColumnName_UserParameters[0,1],
                         ColumnName_UserParameters[0,2],
                         ColumnName_UserParameters[0,3],
                         ColumnName_UserParameters[0,4],
                         ColumnName_UserParameters[0,5],
                         ColumnName_UserParameters[0,6],
                         ColumnName_UserParameters[0,7],
                         ColumnName_UserParameters[0,8],
                         ColumnName_UserParameters[0,9],
                         ColumnName_UserParameters[0,10],
                         ColumnName_UserParameters[0,11],
                         ColumnName_UserParameters[0,12],
                         ColumnName_UserParameters[0,13],
                         ColumnName_UserParameters[0,14],
                         ColumnName_UserParameters[0,15],
                         ColumnName_UserParameters[0,16],
                         ColumnName_UserParameters[0,17],
                         ColumnName_UserParameters[0,18],
                         ColumnName_UserParameters[0,19],
                         ColumnName_UserParameters[0,20],
                         ColumnName_UserParameters[0,21],
                         ColumnName_UserParameters[0,22],
                         ColumnName_UserParameters[0,23],
                         ColumnName_UserParameters[0,24],
                         ColumnName_UserParameters[0,25],
                         ColumnName_UserParameters[0,26],
                         ColumnName_UserParameters[0,27],
                         ColumnName_UserParameters[0,28],
                         ColumnName_UserParameters[0,29],
                         ColumnName_UserParameters[0,30],
                         ColumnName_UserParameters[0,31],
                         ColumnName_UserParameters[1,0],
                         ColumnName_UserParameters[1,1],
                         ColumnName_UserParameters[1,2],
                         ColumnName_UserParameters[1,3],
                         ColumnName_UserParameters[1,4],
                         ColumnName_UserParameters[1,5],
                         ColumnName_UserParameters[1,6],
                         ColumnName_UserParameters[1,7],
                         ColumnName_UserParameters[1,8],
                         ColumnName_UserParameters[1,9],
                         ColumnName_UserParameters[1,10],
                         ColumnName_UserParameters[1,11],
                         ColumnName_UserParameters[1,12],
                         ColumnName_UserParameters[1,13],
                         ColumnName_UserParameters[1,14],
                         ColumnName_UserParameters[1,15],
                         ColumnName_UserParameters[1,16],
                         ColumnName_UserParameters[1,17],
                         ColumnName_UserParameters[1,18],
                         ColumnName_UserParameters[1,19],
                         ColumnName_UserParameters[1,20],
                         ColumnName_UserParameters[1,21],
                         ColumnName_UserParameters[1,22],
                         ColumnName_UserParameters[1,23],
                         ColumnName_UserParameters[1,24],
                         ColumnName_UserParameters[1,25],
                         ColumnName_UserParameters[1,26],
                         ColumnName_UserParameters[1,27],
                         ColumnName_UserParameters[1,28],
                         ColumnName_UserParameters[1,29],
                         ColumnName_UserParameters[1,30],
                         ColumnName_UserParameters[1,31],
                         ColumnName_UserParameters[2,0],
                         ColumnName_UserParameters[2,1],
                         ColumnName_UserParameters[2,2],
                         ColumnName_UserParameters[2,3],
                         ColumnName_UserParameters[2,4],
                         ColumnName_UserParameters[2,5],
                         ColumnName_UserParameters[2,6],
                         ColumnName_UserParameters[2,7],
                         ColumnName_UserParameters[2,8],
                         ColumnName_UserParameters[2,9],
                         ColumnName_UserParameters[2,10],
                         ColumnName_UserParameters[2,11],
                         ColumnName_UserParameters[2,12],
                         ColumnName_UserParameters[2,13],
                         ColumnName_UserParameters[2,14],
                         ColumnName_UserParameters[2,15],
                         ColumnName_UserParameters[2,16],
                         ColumnName_UserParameters[2,17],
                         ColumnName_UserParameters[2,18],
                         ColumnName_UserParameters[2,19],
                         ColumnName_UserParameters[2,20],
                         ColumnName_UserParameters[2,21],
                         ColumnName_UserParameters[2,22],
                         ColumnName_UserParameters[2,23],
                         ColumnName_UserParameters[2,24],
                         ColumnName_UserParameters[2,25],
                         ColumnName_UserParameters[2,26],
                         ColumnName_UserParameters[2,27],
                         ColumnName_UserParameters[2,28],
                         ColumnName_UserParameters[2,29],
                         ColumnName_UserParameters[2,30],
                         ColumnName_UserParameters[2,31],
                         ColumnName_UserParameters[3,0],
                         ColumnName_UserParameters[3,1],
                         ColumnName_UserParameters[3,2],
                         ColumnName_UserParameters[3,3],
                         ColumnName_UserParameters[3,4],
                         ColumnName_UserParameters[3,5],
                         ColumnName_UserParameters[3,6],
                         ColumnName_UserParameters[3,7],
                         ColumnName_UserParameters[3,8],
                         ColumnName_UserParameters[3,9],
                         ColumnName_UserParameters[3,10],
                         ColumnName_UserParameters[3,11],
                         ColumnName_UserParameters[3,12],
                         ColumnName_UserParameters[3,13],
                         ColumnName_UserParameters[3,14],
                         ColumnName_UserParameters[3,15],
                         ColumnName_UserParameters[3,16],
                         ColumnName_UserParameters[3,17],
                         ColumnName_UserParameters[3,18],
                         ColumnName_UserParameters[3,19],
                         ColumnName_UserParameters[3,20],
                         ColumnName_UserParameters[3,21],
                         ColumnName_UserParameters[3,22],
                         ColumnName_UserParameters[3,23],
                         ColumnName_UserParameters[3,24],
                         ColumnName_UserParameters[3,25],
                         ColumnName_UserParameters[3,26],
                         ColumnName_UserParameters[3,27],
                         ColumnName_UserParameters[3,28],
                         ColumnName_UserParameters[3,29],
                         ColumnName_UserParameters[3,30],
                         ColumnName_UserParameters[3,31],

                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_Bank,
                    new string[] {
                         ColumnName_SndEdit,
                         ColumnName_Name,
                         ColumnName_WaveArchiveReference,
                         ColumnName_FilePath,
                         ColumnName_DataSize,
                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_WaveArchive,
                     new string[] {
                         ColumnName_Name,
                         ColumnName_WaveArchiveLoadType,
                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                     });

            AddList(ListName_Player,
                    new string[] {
                         ColumnName_Name,
                         ColumnName_PlayerSoundLimit,
                         ColumnName_PlayerHeapSize,
                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_Group,
                    new string[] {
                         ColumnName_Name,
                         ColumnName_DataSize,
                         ColumnName_GroupOutputType,
                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_GroupItem,
                    new string[] {
                         ColumnName_GroupItemTargetName,
                         ColumnName_GroupItemRegisterType,
                         ColumnName_GroupItemTargetSoundSet,
                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_Instrument,
                    new string[] {
                         ColumnName_ProgramNo,
                         ColumnName_Name,
                         ColumnName_WaveEncoding,
                         ColumnName_FilePath,
                         ColumnName_WaveTime,
                         ColumnName_WaveTick,
                         ColumnName_IsResampleEnabled,
                         ColumnName_SampleRate,
                         ColumnName_WaveBitRate,
                         ColumnName_WaveSampleBit,
                         ColumnName_IsDownMixEnabled,
                         ColumnName_WaveChannel,
                         ColumnName_DataSize,

                         ColumnName_OriginalKey,
                         ColumnName_EnvelopeAttack,
                         ColumnName_EnvelopeHold,
                         ColumnName_EnvelopeDecay,
                         ColumnName_EnvelopeSustain,
                         ColumnName_EnvelopeRelease,
                         ColumnName_Volume,
                         ColumnName_PitchSemitones,
                         ColumnName_PitchCents,
                         ColumnName_InterpolationType,
                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_Percussion,
                    new string[] {
                         ColumnName_WaveEncoding,
                         ColumnName_FilePath,
                         ColumnName_WaveTime,
                         ColumnName_WaveTick,
                         ColumnName_SampleRate,
                         ColumnName_WaveBitRate,
                         ColumnName_WaveSampleBit,
                         ColumnName_WaveChannel,
                         ColumnName_DataSize,

                         ColumnName_OriginalKey,
                         ColumnName_EnvelopeAttack,
                         ColumnName_EnvelopeHold,
                         ColumnName_EnvelopeDecay,
                         ColumnName_EnvelopeSustain,
                         ColumnName_EnvelopeRelease,
                         ColumnName_Volume,
                         ColumnName_PitchSemitones,
                         ColumnName_PitchCents,
                         ColumnName_Pan,
                         ColumnName_PercussionMode,
                         ColumnName_KeyGroup,
                         ColumnName_InterpolationType,
                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_FindResult,
                    new string[] {
                         ColumnName_Name,
                         ColumnName_ItemLocation,
                         ColumnName_Comment,
                         ColumnName_Comment1,
                         ColumnName_Comment2,
                         ColumnName_Comment3,
                         ColumnName_Comment4,
                         ColumnName_Comment5,
                         ColumnName_Comment6,
                         ColumnName_Comment7,
                         ColumnName_Comment8,
                         ColumnName_Comment9,
                    });

            AddList(ListName_MultipleBank,
                    new string[] {
                         ColumnName_SoundSetBankReferences,
                    });

            AddList(ListName_History,
                    new string[] {
                    ColumnName_Name,
                    ColumnName_DateTime,
                    });

            AddList(ListName_MeasureReferenceCountFilePath,
                     new string[] {
                         ColumnName_FilePath,
                         ColumnName_ReferenceCount,
                     });

            AddList(ListName_MeasureReferenceCountInstrument,
                     new string[] {
                         ColumnName_Name,
                         ColumnName_ReferenceCount,
                         ColumnName_FilePath,
                     });
        }

        /// <summary>
        ///
        /// </summary>
        protected override void InitializeColumns()
        {
            base.InitializeColumns();

            AddColumn(
                      new ListColumnTrait(ColumnName_AuxCSend,
                                           MessageResource.HeaderText_AuxCSend,
                                           48, 48,
                                           ListColumnTrait.HorizontalAlignment.Left));

            AddColumn(
                      new ListColumnTrait(ColumnName_RemoteFilter,
                                           MessageResource.HeaderText_RemoteFilter,
                                           64, 32,
                                           ListColumnTrait.HorizontalAlignment.Left));
            AddColumn(
                      new ListColumnTrait(ColumnName_TrackAuxCSend,
                                           MessageResource.HeaderText_TrackAuxCSend,
                                           48, 48,
                                           ListColumnTrait.HorizontalAlignment.Left));
        }
    }
}
