﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.ComponentModel;
    using Core.Parameters;
    using ToolDevelopmentKit;

    public class SendsCommon : Sends
    {
        private const string PropertyNameAuxCSend = nameof(ProjectParameterNamesCommon.Sends.AuxCSend);

        private int auxCSend = 0;

        /// <summary>
        ///
        /// </summary>
        public override ICloneable Clone()
        {
            SendsCommon sends = new SendsCommon();

            sends.MainSend = this.MainSend;
            sends.AuxASend = this.AuxASend;
            sends.AuxBSend = this.AuxBSend;
            sends.AuxCSend = this.AuxCSend;

            return sends;
        }

        [ValueRange(0, 127)]
        public int AuxCSend
        {
            get { return this.auxCSend; }
            set
            {
                if (this.auxCSend == value)
                {
                    return;
                }

                this.auxCSend = value;
                this.OnNotifyPropertyChanged(new PropertyChangedEventArgs(PropertyNameAuxCSend));
            }
        }
    }
}
