﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using NintendoWare.SoundFoundation.Core.Parameters;

    public class StreamSound : StreamSoundBase
    {
        ///--------------------------------
        /// <summary>
        /// リモコン
        /// </summary>
        public int RemoteFilter
        {
            get { return GetIntValue(ProjectParameterNamesCommon.RemoteFilter); }
            set { SetIntValue(ProjectParameterNamesCommon.RemoteFilter, value); }
        }

        /// <summary>
        /// センド設定を取得または設定します。
        /// </summary>
        public new SendsCommon Sends
        {
            get { return this.GetValue<SendsCommon>(ProjectParameterNames.Sound.Sends); }
            set { this.SetValue<SendsCommon>(ProjectParameterNames.Sound.Sends, value); }
        }

        ///--------------------------------
        /// <summary>
        /// パラメータを初期化します。
        /// </summary>
        protected override void InitializeParameters()
        {
            base.InitializeParameters();

            SetInstanceIntValue(ProjectParameterNamesCommon.RemoteFilter, 0, 0, 127);

            // ピッチの有効範囲がCafeでは違うので、再登録します。
            this.Parameters.RemoveValue(ProjectParameterNames.Pitch);
            this.Parameters.AddValue(ProjectParameterNames.Pitch,
                                      new PitchParameterValue(1.0F, 0.00001F, 8.0F));

            //
            StreamSoundSendsParameterValue sendsParam =
                new StreamSoundSendsParameterValue(new SendsCommon());
            this.Parameters.RemoveValue(ProjectParameterNames.Sound.Sends);
            Parameters.AddValue(ProjectParameterNames.Sound.Sends, sendsParam);

            // ストリームサウンドバイナリ依存パラメータ
            this.SetParameterAttributes(ProjectParameterNames.Pitch, ParameterAttributes.ComputeHash);

            // sndedit 転送対象パラメータ
            this.SetParameterAttributes(ProjectParameterNamesCommon.RemoteFilter, ParameterAttributes.ComputeSndeditTransferHash);
            this.SetParameterAttributes(ProjectParameterNames.Sound.Sends, ParameterAttributes.ComputeSndeditTransferHash);
        }
    }
}
