﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using NintendoWare.SoundFoundation.Core;

    public class SoundSetComponentFactory : ObjectAggregateFactory<Type, Component>
    {
        public SoundSetComponentFactory()
        {
            this.Factories.Add(typeof(SoundSet), new ComponentFactory<SoundSet>());

            this.Factories.Add(typeof(StreamSoundPack), new ComponentFactory<StreamSoundPack>());
            this.Factories.Add(typeof(WaveSoundSetPack), new ComponentFactory<WaveSoundSetPack>());
            this.Factories.Add(typeof(SequenceSoundSetPack), new ComponentFactory<SequenceSoundSetPack>());
            this.Factories.Add(typeof(SequenceSoundPack), new ComponentFactory<SequenceSoundPack>());
            this.Factories.Add(typeof(SoundSetBankPack), new ComponentFactory<SoundSetBankPack>());
            this.Factories.Add(typeof(PlayerPack), new ComponentFactory<PlayerPack>());
            this.Factories.Add(typeof(WaveArchivePack), new ComponentFactory<WaveArchivePack>());
            this.Factories.Add(typeof(GroupPack), new ComponentFactory<GroupPack>());

            this.Factories.Add(typeof(StreamSoundBase), new ComponentFactory<StreamSound>());
            this.Factories.Add(typeof(StreamSoundTrackBase), new ComponentFactory<StreamSoundTrack>());
            this.Factories.Add(typeof(WaveSoundSetBase), new ComponentFactory<WaveSoundSetBase>());
            this.Factories.Add(typeof(WaveSoundBase), new ComponentFactory<WaveSound>());
            this.Factories.Add(typeof(SequenceSoundSetBase), new ComponentFactory<SequenceSoundSetBase>());
            this.Factories.Add(typeof(SequenceSoundBase), new ComponentFactory<SequenceSound>());
            this.Factories.Add(typeof(SoundSetBankBase), new ComponentFactory<SoundSetBank>());
            this.Factories.Add(typeof(PlayerBase), new ComponentFactory<PlayerBase>());
            this.Factories.Add(typeof(WaveArchiveBase), new ComponentFactory<WaveArchiveBase>());
            this.Factories.Add(typeof(GroupBase), new ComponentFactory<GroupBase>());
            this.Factories.Add(typeof(GroupItemBase), new ComponentFactory<GroupItemBase>());
        }
    }
}
