﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundFoundation.FileFormats.Wave
{
    public class WaveFileOpus : WaveFile
    {
        private bool isLoop = false;
        private IList<IRegionInfo> regions = null;
        private IList<IMarkerInfo> markers = null;

        public override int ChannelCount { get; set; }
        public override long FrameCount { get; set; }
        public override int SampleBit { get; set; }
        public override int SampleRate { get; set; }
        public override int OriginalKey { get; set; }

        public override double WaveTime { get; set; }

        public override bool IsLoop { get { return this.isLoop; } }
        public override long LoopStartFrame { get; set; }
        public override long LoopEndFrame { get; set; }

        public override IList<IRegionInfo> Regions { get { return this.regions; } }
        public override IList<IMarkerInfo> Markers { get { return this.markers; } }
    }
}
