﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using Binarization;

    internal class Bool2ByteConverter : TypeConverter<bool, Byte>
    {
        /// <summary>
        /// 値を変換します。
        /// </summary>
        /// <param name="value">変換する値を指定します。</param>
        /// <returns>変換後の値を返します。</returns>
        public override Byte ConvertTo(bool value)
        {
            return (Byte)(value ? 0x01 : 0x00);
        }

        /// <summary>
        /// 値を変換します。
        /// </summary>
        /// <param name="value">変換する値を指定します。</param>
        /// <returns>変換後の値を返します。</returns>
        public override bool ConvertFrom(Byte value)
        {
            return !(value == 0);
        }
    }
}
