﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Runtime.InteropServices;
    using NintendoWare.SoundFoundation.Binarization;
    using NintendoWare.SoundFoundation.Core.Collections;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    internal class PatriciaTreeNodeBinary
    {
        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public UInt16 Flags
        {
            get { return this.IsLeaf ? (UInt16)1 : (UInt16)0; }
        }

        public UInt16 Bit
        {
            get { return this.IsLeaf ? (UInt16)0xFFFF : (UInt16)this.Node.Bit; }
        }

        public UInt32 Left
        {
            get
            {
                return (this.Node.Left != null) ? (UInt32)this.Node.Left.Index : (UInt32)0xFFFFFFFF;
            }
        }

        public UInt32 Right
        {
            get
            {
                return (this.Node.Right != null) ? (UInt32)this.Node.Right.Index : (UInt32)0xFFFFFFFF;
            }
        }

        public UInt32 StringID { get; set; }

        public BinaryItemID ItemID { get; set; }

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public PatriciaTree.INode Node { get; set; }

        private bool IsLeaf
        {
            get { return this.Node is PatriciaTree.ILeaf; }
        }
    }
}
