﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    internal class CommonFileHeader
    {
        private const UInt16 ByteOrderValue = 0xfeff;

        private string signature = "    ";
        private Byte majorVersion = 0;
        private Byte minorVersion = 0;
        private Byte microVersion = 0;
        private Byte binaryBugFixVersion = 0;

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public string Signature
        {
            get { return this.signature; }
            set
            {
                if (null == value) { throw new ArgumentNullException("value"); }
                if (4 != value.Length) { throw new ArgumentOutOfRangeException("value"); }
                this.signature = value;
            }
        }

        public UInt16 ByteOrder
        {
            get { return CommonFileHeader.ByteOrderValue; }
        }

        [DomObjectReference(
            HasSize = true, SizeType = SizeType.OffsetToNext, SizeValueType = typeof(UInt16))]
        public CommonFileHeader FileHeader
        {
            get { return this; }
        }

        public UInt32 Version
        {
            get
            {
                return (UInt32)(
                    (this.majorVersion << 24) |
                    (this.minorVersion << 16) |
                    (this.microVersion << 8) |
                    this.binaryBugFixVersion);
            }
            set
            {
                this.majorVersion = (Byte)((value >> 24) & 0xFF);
                this.minorVersion = (Byte)((value >> 16) & 0xFF);
                this.microVersion = (Byte)((value >> 8) & 0xFF);
                this.binaryBugFixVersion = (Byte)(value & 0xFF);
            }
        }

        [DomObjectReference(HasSize = true, SizeType = SizeType.OffsetToNext)]
        public object File { get; set; }

        public virtual UInt16 BlockCount { get; set; }

        public UInt16 Padding
        {
            get { return 0; }
        }

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public Byte MajorVersion
        {
            get { return this.majorVersion; }
            set { this.majorVersion = value; }
        }

        [DomIgnoreField]
        public Byte MinorVersion
        {
            get { return this.minorVersion; }
            set { this.minorVersion = value; }
        }

        [DomIgnoreField]
        public Byte MicroVersion
        {
            get { return this.microVersion; }
            set { this.microVersion = value; }
        }

        [DomIgnoreField]
        public Byte BinaryBugFixVersion
        {
            get { return this.binaryBugFixVersion; }
            set { this.binaryBugFixVersion = value; }
        }
    }
}
