﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Runtime.InteropServices;
    using Binarization;
    using ToolDevelopmentKit;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    internal class CommonBlock
    {
        private CommonBlockHeader header = new CommonBlockHeader();
        private object body = null;

        public CommonBlock()
        {
            this.header.Block = this;
        }

        public CommonBlock(string signature)
            : this()
        {
            Ensure.Argument.NotNull(signature);

            this.header.Signature = signature;
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        [DomField("Header")]
        public CommonBlockHeader Header
        {
            get { return this.header; }
        }

        [DomField("Body")]
        public object Body
        {
            get { return this.body; }
            set { this.body = value; }
        }
    }

    [StructLayout(LayoutKind.Sequential)]
    internal class CommonBlock<TBody> : CommonBlock
        where TBody : class
    {
        public CommonBlock()
            : base()
        {
        }

        public CommonBlock(string signature)
            : base(signature)
        {
        }

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public new TBody Body
        {
            get { return base.Body as TBody; }
            set { base.Body = value; }
        }
    }
}
