﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.WaveElements
{
    using System;
    using System.Collections.Generic;
    using System.IO;
    using System.Runtime.InteropServices;
    using Binarization;
    using Projects;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.WaveFile_ChannelInfo)]
    internal class ChannelInfo
    {
        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        [DomObjectReference(
            OriginTag = "BinaryRoot", OriginPath = "Blocks/DATA/Body",
            HasType = true, HasOffset = true)]
        public ByteStream Data { get; set; }

        [DomObjectReference(
            OriginTag = "Element", HasType = true, HasOffset = true)]
        public object CodecInformation { get; set; }

        public UInt32 Reserved
        {
            get { return 0; }
        }
    }
}
