﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.StreamSoundElements
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.Runtime.InteropServices;
    using NintendoWare.SoundFoundation.Binarization;
    using NintendoWare.SoundFoundation.Projects;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.StreamSoundFile_MarkerInfo)]
    internal class MarkerInfo
    {
        public const int MaxName = 64;          /// 終端文字を含む文字列長

        //-----------------------------------------------------------------

        private string name = string.Empty;

        //-----------------------------------------------------------------

        public MarkerInfo()
        {
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        /// <summary>
        /// スタートフレームを取得または設定します。
        /// </summary>
        public UInt32 Position { get; set; }

        public UInt32 Padding { get; set; }

        /// <summary>
        /// リージョンの名前を取得または設定します。
        /// </summary>
        public string Name
        {
            get { return this.name; }

            set
            {
                if (value == null || value.Length >= MaxName)
                {
                    throw new Exception("invalid marker name.");
                }

                this.name = value;
            }
        }

        /// <summary>
        /// Name を 64 バイトに調整するためのパディングを取得します。
        /// </summary>
        public byte[] NamePadding
        {
            get { return new byte[MaxName - this.Name.Length]; }
        }
    }
}
