﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveXmlElements
{
    using System;
    using System.Globalization;
    using System.Xml;
    using System.Xml.Serialization;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// サウンドセットアイテムの情報を格納します。
    /// </summary>
    [Serializable]
    public class SoundSetItemXml
    {
        private uint InvalidFileID = uint.MaxValue;

        public SoundSetItemXml()
        {
            this.FileID = InvalidFileID;
        }

        /// <summary>
        /// 16進数表記の ItemID（テキスト）を取得または設定します。
        /// </summary>
        [XmlAttribute("ID")]
        public string IDText { get; set; }

        /// <summary>
        /// 名前を取得または設定します。
        /// </summary>
        [XmlAttribute("Name")]
        public string Name { get; set; }

        /// <summary>
        /// ファイルID（テキスト）を取得または設定します。
        /// </summary>
        [XmlAttribute("FileID")]
        public string FileIDText { get; set; }

        [XmlIgnore]
        public bool FileIDTextSpecified
        {
            get { return this.FileID != InvalidFileID; }
        }

        /// <summary>
        /// 16進数表記の ItemID（数値）を取得または設定します。
        /// </summary>
        [XmlIgnore]
        internal BinaryItemID ID
        {
            get
            {
                if (this.IDText == null || this.IDText.Length == 0)
                {
                    return BinaryItemID.InvalidValue;
                }

                return UInt32.Parse(this.IDText, NumberStyles.HexNumber);
            }
            set
            {
                Ensure.Argument.NotNull(value);
                this.IDText = value.Value.ToString("X8");
            }
        }

        /// <summary>
        /// 16進数表記のファイルID（数値）を取得または設定します。
        /// </summary>
        [XmlIgnore]
        internal UInt32 FileID
        {
            get
            {
                if (this.FileIDText == null || this.FileIDText.Length == 0)
                {
                    return BinaryItemID.InvalidValue;
                }

                return UInt32.Parse(this.FileIDText, NumberStyles.HexNumber);
            }
            set
            {
                Ensure.Argument.NotNull(value);
                this.FileIDText = value.ToString("X8");
            }
        }
    }
}
