﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveXmlElements
{
    using System;
    using System.Xml;
    using System.Xml.Serialization;

    /// <summary>
    /// 外部ファイル情報を格納します。
    /// </summary>
    [Serializable]
    public class ExternalFileXml : FileXml
    {
        [XmlAttribute("ExternalPath")]
        public string ExternalPath { get; set; }

        [XmlAttribute("Size")]
        public ulong Size { get; set; }

        [XmlIgnore]
        public bool SizeSpecified
        {
            get { return this.Size != ulong.MaxValue; }
        }
    }
}
