﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using Binarization;
    using Projects;

    internal class DecayCurve3D2ByteConverter : TypeConverter<DecayCurve3D, Byte>
    {
        private enum DecayCurve
        {
            Log = 1,
            Linear = 2,
        }

        /// <summary>
        /// 値を変換します。
        /// </summary>
        /// <param name="value">変換する値を指定します。</param>
        /// <returns>変換後の値を返します。</returns>
        public override Byte ConvertTo(DecayCurve3D value)
        {
            switch (value)
            {
                case DecayCurve3D.Log:
                    return (Byte)DecayCurve.Log;
                case DecayCurve3D.Linear:
                    return (Byte)DecayCurve.Linear;
            }

            throw new Exception("internal error : invalid DecayCurve3D.");
        }

        /// <summary>
        /// 値を変換します。
        /// </summary>
        /// <param name="value">変換する値を指定します。</param>
        /// <returns>変換後の値を返します。</returns>
        public override DecayCurve3D ConvertFrom(Byte value)
        {
            switch ((DecayCurve)value)
            {
                case DecayCurve.Log:
                    return DecayCurve3D.Log;

                case DecayCurve.Linear:
                    return DecayCurve3D.Linear;
            }

            throw new Exception("internal error : invalid DecayCurve3D.");
        }
    }
}
